CREATE OR REPLACE FUNCTION auftg__lief_rech_data(IN agid INTEGER, OUT liefdat TEXT, OUT liefdef BOOLEAN, OUT liefabgdat TEXT, OUT rechdat TEXT, OUT rechdef BOOLEAN, OUT rechbetrag NUMERIC(12,4)) AS $$
 DECLARE anz INTEGER;
         r RECORD;
 BEGIN
   --caching
   FOR r IN SELECT c_resultc, c_resultn, c_param1 FROM tcache.function_cache WHERE c_funcname='auftg__lief_rech_data' AND c_param0=agid AND NOT c_dirty LOOP
        CASE WHEN r.c_param1='liefdat'    THEN liefdat   :=r.c_resultc;
             WHEN r.c_param1='liefdef'    THEN liefdef   :=r.c_resultc;
             WHEN r.c_param1='liefabgdat' THEN liefabgdat:=r.c_resultc;
             WHEN r.c_param1='rechdat'    THEN rechdat   :=r.c_resultc;
             WHEN r.c_param1='rechdef'    THEN rechdef   :=r.c_resultc;
             WHEN r.c_param1='rechbetrag' THEN rechbetrag:=r.c_resultn;
        END CASE;
   END LOOP;
   IF found THEN
        RETURN;
   END IF;
   --end caching
   SELECT
    beld_dokunr||e'\n'||COALESCE(to_char(beld_erstelldatum, 'DD.MM.YY'), ''),
    --lieferschein definitiv und Rechnung definitiv, abgangsdatum spielt keine rolle
    --wegen automatisch erstellten rechnungen durch lagerabgang
    (beld_definitiv AND COALESCE(be_def, false))
    OR
    --lieferschein def und Abgangsdatum -> zählt der Lieferschein als defintiv, rechnung spielt keine rolle
    (beld_definitiv AND belp_termin IS NOT NULL),
    --Abgangsdatum
    belp_termin
   INTO
    liefdat, liefdef, liefabgdat
   FROM
    lieferschein JOIN lieferschein_pos ON belp_dokument_id = beld_id
                 LEFT OUTER JOIN belzeil_grund ON bz_belp_id=belp_id
                 LEFT OUTER JOIN belkopf ON be_bnr=bz_be_bnr
   WHERE belp_ag_id=agid
   ORDER BY beld_dokunr DESC LIMIT 1;
   --
   SELECT
    bz_be_bnr||E'\n'||COALESCE(to_char(belkopf.be_bdat, 'DD.MM.YY'), ''), be_def
   INTO
    rechdat, rechdef
   FROM
    auftg JOIN belzeil_grund ON (bz_auftg = ag_nr) AND (bz_auftgpos = ag_pos)
          JOIN belkopf ON be_bnr=bz_be_bnr AND (be_prof='R' OR be_prof='T')
   WHERE ag_id=agid
   ORDER BY be_bnr DESC LIMIT 1;
   --
   IF liefdat IS NULL AND rechdat IS NULL THEN
        PERFORM tcache.function_cache_setcache_2param('auftg__lief_rech_data', agid, 'liefdat',  NULL, '');
        RETURN;
   END IF;
   --
   SELECT count(1) INTO anz FROM lieferschein_pos WHERE belp_ag_id=agid;
   liefdat:='['||CAST(anz AS VARCHAR)||'] '||COALESCE(liefdat,'');
   SELECT count(1), SUM(bz_tot_basis_w*IFTHEN(be_prof='G', -1, 1)) INTO anz, rechbetrag FROM belzeil_grund JOIN belkopf ON be_bnr=bz_be_bnr JOIN auftg ON ag_nr=bz_auftg AND ag_pos=bz_auftgpos WHERE ag_id=agid;
   --ACHTUNG hier muß noch die Abschlagsprozentzahl berücksichtigt werden!
   rechdat:='['||CAST(anz AS VARCHAR)||'] '||rechdat;
   --caching schreiben
   PERFORM tcache.function_cache_setcache_2param('auftg__lief_rech_data', agid, 'liefdat',    NULL, liefdat);
   PERFORM tcache.function_cache_setcache_2param('auftg__lief_rech_data', agid, 'liefdef',    NULL, liefdef::VARCHAR);
   PERFORM tcache.function_cache_setcache_2param('auftg__lief_rech_data', agid, 'liefabgdat', NULL, liefabgdat);
   PERFORM tcache.function_cache_setcache_2param('auftg__lief_rech_data', agid, 'rechdat',    NULL, rechdat);
   PERFORM tcache.function_cache_setcache_2param('auftg__lief_rech_data', agid, 'rechdef',    NULL, rechdef::VARCHAR);
   PERFORM tcache.function_cache_setcache_2param('auftg__lief_rech_data', agid, 'rechbetrag', rechbetrag);
   --end caching schreiben
   RETURN;
 END $$ LANGUAGE plpgsql STABLE;


--

-- ###### FUNKTIONEN ZUR WERTBERECHNUNG
--
--

--

-- Holt den Wert einer Auftragsposition
-- !!!!!!!!!!!!!!!!!!!!!!!!!!!
-- Funktion nutzt Cache, Änderungen müssen ggf. im Caching nachgesetzt werden.
-- !!!!!!!!!!!!!!!!!!!!!!!!!!!
-- Beachte FUNCTION auftg__b_iu__possum() RETURNS TRIGGER
CREATE OR REPLACE FUNCTION auftg_pos_wert_calc(
    agid                  INTEGER,
    offen                 BOOLEAN,          -- Nur den noch nicht gelieferten Wert der Pos (z.B. 5 verkauft, 3 geliefert -> offen = Wert für 2).
    basis_w               BOOLEAN,          -- Fremdwährung in Stammwährung ausgeben.
    withtotalpos          BOOLEAN = false,  -- Steuerung für Preis enthält Unterposition. Nur den realen Wert. D.h., wenn Pos den Wert der UnterPos enthält, hat diese einen Realwert von 0, da die UnterPos den richtigen Wert enhalten.
    forceOptionalPosWert  BOOLEAN = false,  -- Auch nicht werthaltige Pos hinzuziehen. Optinalpositionen sind sonst immer 0 (Wert).
    forceStornoPosWert    BOOLEAN = false,  -- Auch stornierte Pos hinzuziehen.
    withgesrab            BOOLEAN = true    -- Steuerung für Gesamtrabatt im Zusammenhang mit Preis enthält Unterposition.
  ) RETURNS NUMERIC(16,4) AS $$
  DECLARE rec_a  RECORD;
          wert   NUMERIC(16,4);
          abzu   NUMERIC(16,4);
          result NUMERIC(16,4);
  BEGIN
    -- caching
    IF withgesrab THEN -- Dies ist nur false, wenn HauptPos nach Unterpos gerechnet wird. Diese Zwischensumme ohne Gesamtrabatt wird NIE gespeichert.
        SELECT c_resultn INTO result FROM tcache.function_cache WHERE c_funcname = 'auftg_pos_wert_calc' AND c_param0 = agid AND c_param1::BOOL = offen AND c_param2::BOOL = basis_w AND c_param3::BOOL = withtotalpos AND c_param4::BOOL = forceOptionalposWert AND c_param5::BOOL = forceStornoPosWert AND NOT c_dirty;

        IF result IS NOT NULL THEN  RETURN result;  END IF;
    END IF;

    SELECT
      ag_astat,
      ag_nr,
      ag_pos,
      IFTHEN( offen, ag_stk_uf1 - GREATEST( ag_stkl, ag_stkf, 0 ), ag_stk_uf1 ) AS menge,
      ag_vkp_uf1,
      ag_kurs,
      ag_canrabatt,
      ag_arab,
      auftg_get_auftgmainpos( ag_id, true ) AS totalposagid,
      atd_gesrab,
      ag_vkptotalpos,
      ag_done,
      ag_storno,
      ag_nstatistik
    INTO rec_a
    FROM auftg
      LEFT JOIN auftgtxt ON at_astat = ag_astat AND at_nr = ag_nr
      LEFT JOIN auftgdokutxt ON atd_dokunr = ag_dokunr
    WHERE ag_id = agid;

    -- Achtung - Haupt- und Unterpositionen - Poswertverteilung
    IF (offen AND rec_a.ag_done) OR (rec_a.ag_storno AND NOT forceStornoPosWert) OR (rec_a.ag_nstatistik AND NOT forceoptionalposwert) THEN
        PERFORM tcache.function_cache_setcache_auftg_pos_wert_calc(agid, offen, basis_w, withtotalpos, forceOptionalposWert, forceStornoPosWert, 0);

        RETURN 0;
    END IF;

    IF rec_a.ag_vkptotalpos AND NOT withtotalpos THEN
        -- Preis enthält Unterposition: Es muss Unterposition geben, sonst ist der Preis vollständig gültig.
        IF EXISTS(SELECT true FROM auftg WHERE ag_astat = rec_a.ag_astat AND ag_nr = rec_a.ag_nr AND ag_hpos = rec_a.ag_pos) THEN
            IF withgesrab THEN
                PERFORM tcache.function_cache_setcache_auftg_pos_wert_calc(agid, offen, basis_w, withtotalpos, forceOptionalposWert, forceStornoPosWert, 0);
            END IF;

            RETURN 0;
        END IF;
    END IF;

    SELECT
      SUM( COALESCE(az_abzubetrag, 0) * az_anz )
    INTO abzu
    FROM auftgabzu
    WHERE az_ag_id = agid
      AND IfThen( NOT offen, true, az_bebnr IS NULL );

    IF offen AND rec_a.menge < 0 THEN
        PERFORM tcache.function_cache_setcache_auftg_pos_wert_calc(agid, offen, basis_w, withtotalpos, forceOptionalposWert, forceStornoPosWert, 0 + COALESCE(abzu, 0));

        RETURN 0 + COALESCE(abzu, 0);
    END IF;

    -- Wenn HauptPos auf gleichem Dokument wie UnterPos, werden alle gleichartig angetriggert und die HauptPos und die UnterPos sehen alle den Gesamtrabatt.
    -- Wenn HauptPos und UnterPos ungleich auf dem Dokument stehen, sehen diese unterschiedlich den Rabatt.
    -- => UnterPos ziehen ihren Rabatt immer aus der HauptPos, unabhängig von der Dokumentzuweisung.
    IF NOT withgesrab OR rec_a.totalposagid IS NOT NULL THEN
        rec_a.atd_gesrab := 0;
    ELSE
        -- In UnterPos wird der Gesamtrabatt durch Zuweisung von der HauptPos bereits berücksichtigt. Die UnterPos darf den Gesamtrabatt daher nicht noch einmal ziehen.
        IF NOT rec_a.ag_vkptotalpos AND rec_a.totalposagid IS NOT NULL THEN
            rec_a.atd_gesrab := atd_gesrab FROM auftg, auftgdokutxt WHERE ag_id = rec_a.totalposagid AND atd_dokunr = ag_dokunr;
        END IF;
    END IF;

    IF rec_a.ag_canrabatt THEN
        wert := rec_a.ag_vkp_uf1 * ( 1 - COALESCE( rec_a.ag_arab, 0 ) / 100) * ( 1 - COALESCE( rec_a.atd_gesrab, 0 ) / 100 );
    ELSE -- nicht rabattfähig
        wert := rec_a.ag_vkp_uf1;
    END IF;

    result := (
      ( ( wert * rec_a.menge ) + COALESCE( abzu, 0 )
      ) * IfThen( basis_w, rec_a.ag_kurs,  1 )        -- Fremdwährung in Stammwährung ausgeben.
    )::NUMERIC(16,4);

    IF withgesrab THEN -- Dies ist nur false, wenn HauptPos nach UnterPos gerechnet wird. Diese Zwischensumme ohne Gesamtrabatt wird NIE gespeichert.
        PERFORM tcache.function_cache_setcache_auftg_pos_wert_calc(agid, offen, basis_w, withtotalpos, forceOptionalposWert, forceStornoPosWert, result);
    END IF;

    RETURN result;
  END $$ LANGUAGE plpgsql STABLE;
--

--SUMMEN
 CREATE OR REPLACE FUNCTION auftg_pos_wert_offen_basis_w(agid INTEGER) RETURNS NUMERIC(16,4) AS $$
  BEGIN
   RETURN public.auftg_pos_wert_calc(agid, true, true);
  END $$ LANGUAGE plpgsql STABLE;

 CREATE OR REPLACE FUNCTION auftg_pos_wert_offen(agid INTEGER) RETURNS NUMERIC(16,4) AS $$
  BEGIN
   RETURN public.auftg_pos_wert_calc(agid, true, false);
  END $$ LANGUAGE plpgsql STABLE;

 CREATE OR REPLACE FUNCTION auftg_pos_wert_basis_w(agid INTEGER) RETURNS NUMERIC(16,4) AS $$
  BEGIN
   RETURN public.auftg_pos_wert_calc(agid, false, true);
  END $$ LANGUAGE plpgsql STABLE;

 CREATE OR REPLACE FUNCTION auftg_pos_wert(agid INTEGER) RETURNS NUMERIC(16,4) AS $$
  BEGIN
   RETURN public.auftg_pos_wert_calc(agid, false, false);
  END $$ LANGUAGE plpgsql STABLE;


 /*Nettosumme Auftrag - Pos.Rabatt/Gesamtrabatt mit einrechnen, falls Artikel rabattfähig*/
 CREATE OR REPLACE FUNCTION sum_auftg(agastat VARCHAR, agnr VARCHAR) RETURNS NUMERIC AS $$
  DECLARE
    rahmenwert NUMERIC(12,2);
    poswert    NUMERIC(12,2);
  BEGIN

   -- insgesamten Rahmenwert auf Auftragsnummern-Ebene erhalten, wenn mit pos=0 und Unterpositionen gearbeitet wird.
   IF agastat ='E' THEN
        rahmenwert :=   (tauftg.auftgr__rahmen_info__stko_offen__by__ag_id__get(ag_id) * ag_ep_netto)
                      + twawi.auftg__abzu__netto__by__ag_id(ag_id) FROM auftg WHERE ag_astat = 'E' AND ag_nr=agnr AND ag_pos = 0;
   END IF;

   poswert := SUM(
             auftg_pos_wert_calc(
               ag_id,
               offen => false,
               basis_w => false,
               withtotalpos => true
             )
    ) FROM auftg
    WHERE
      ag_astat = agastat AND
      ag_nr = agnr AND
      NOT ag_nstatistik AND
      ag_pos > 0 and
      auftg_get_auftgmainpos(
          _auftg_id                                => ag_id,
          _suche_nichtwerthaltigen_parent          => true,
          _suche_obersten_nichtwerthaltigen_parent => true
      ) is null ;

   RETURN
       COALESCE( rahmenwert, 0)
     + COALESCE( poswert, 0 );

  END $$ LANGUAGE plpgsql STABLE;

-- Summe inkl. Positions/Gesamtrabatt über alle Aufträge mit einer Dokument-Nr.
CREATE OR REPLACE FUNCTION sum_auftg_dokunr(
      _dokument_nummer INTEGER,
      _brutto BOOLEAN = false,
      _inkl_doku_rabatt BOOLEAN = true
      ) RETURNS NUMERIC AS $$
    DECLARE
      _sum NUMERIC;
    BEGIN
      _sum := SUM(
               auftg_pos_wert_calc(
                 ag_id,
                 offen => false,
                 basis_w => false,
                 withtotalpos => true,
                 withgesrab => _inkl_doku_rabatt,
                 forcestornoposwert => false,
                 forceoptionalposwert => false
               )
               *
               IFTHEN( _brutto ,
                  (1 + COALESCE(ag_ustpr, 0) / 100),
                  1
               )
              ) FROM auftg
                WHERE
                    ag_dokunr = _dokument_nummer
                AND auftg_get_auftgmainpos(
                        _auftg_id                                => ag_id,
                        _suche_nichtwerthaltigen_parent          => true,
                        _suche_obersten_nichtwerthaltigen_parent => true
                    ) IS null
                AND NOT ag_nstatistik;

      RETURN COALESCE( Round( _sum , 2 ) , 0 );
    END $$ LANGUAGE plpgsql STABLE;
--
-- https://redmine.prodat-sql.de/issues/13868
CREATE OR REPLACE FUNCTION sum_auftg_dokunr(
      _dokument_nummer VARCHAR,
      _brutto BOOLEAN = false,
      _inkl_doku_rabatt BOOLEAN = true
  ) RETURNS NUMERIC AS $$

      SELECT sum_auftg_dokunr(
          _dokument_nummer::INTEGER,
          _brutto,
          _inkl_doku_rabatt
      );

  $$ LANGUAGE SQL;
--

-- Angebots Info

CREATE OR REPLACE FUNCTION tauftg.auftg__angebot_info__by__ag_ang_ag_id(
    IN  _ag_ang_ag_id           integer,
    OUT ag_ang_ag_nr            varchar,
    OUT ag_ang_ag_pos           integer,
    OUT ag_ang_ag_aknr          varchar,
    OUT ag_ang_ag_aknr_referenz varchar,
    OUT ag_ang_ag_akbz          varchar
    )
    RETURNS record
    AS $$
        SELECT ag_nr, ag_pos, ag_aknr, ag_aknr_referenz, ag_akbz FROM auftg WHERE ag_id = _ag_ang_ag_id;
    $$ LANGUAGE sql STABLE STRICT;



-- RAHMEN
 -- gesamte Menge des Rahmenauftrags
 -- SELECT tsystem.function__drop_by_regex('tauftg.auftgr__rahmen_info__stk__by__ag_id__get', _commit => true);
 CREATE OR REPLACE FUNCTION tauftg.auftgr__rahmen_info__stk__by__ag_id__get(
     IN  _agid_rahmen integer,
     OUT agstkuf1     numeric,
     OUT mid          integer
     )
     RETURNS record
     AS $$
     BEGIN
       SELECT ag_stk_uf1,
              ag_mcv
         INTO agstkuf1,
              mid
         FROM auftg
        WHERE ag_id = _agid_rahmen
          AND (    ag_astat = 'R'
               OR (ag_astat = 'E' AND ag_pos = 0)
               );
     END $$ LANGUAGE plpgsql STABLE RETURNS NULL ON NULL INPUT;
 CREATE OR REPLACE FUNCTION z_99_deprecated.rahmen_stk_auftg(
     IN _agid_rahmen integer
     )
     RETURNS numeric
     AS $$
        SELECT agstkuf1 FROM tauftg.auftgr__rahmen_info__stk__by__ag_id__get(_agid_rahmen)
     $$ LANGUAGE sql STABLE;

    -- offene Menge des Rahmenauftrags // bei Verwendung mit Pos Rahmen COALESCE(ag_rahmen_ag_id, ag_id)

 -- SELECT tsystem.function__drop_by_regex('tauftg.auftgr__rahmen_info__stko_offen__by__ag_id__get', _commit => true);
 -- ACHTUNG: -- Dummy Function in art.sql
 CREATE OR REPLACE FUNCTION tauftg.auftgr__rahmen_info__stko_offen__by__ag_id__get(
     IN _agid_rahmen integer
     )
     RETURNS numeric
     AS $$
     DECLARE _auftgstk      numeric;
             _auftgrahmen   record;
     BEGIN
       _auftgrahmen := tauftg.auftgr__rahmen_info__stk__by__ag_id__get(_agid_rahmen);

       -- eingegebene ag_id ist kein Rahmen, dann weg
       IF _auftgrahmen.agstkuf1 IS null THEN
          RETURN null;
       END IF;

       -- Alle Abrufe zur ag_id
       _auftgstk  := ( SELECT sum(
                                  greatest(
                                      ag_stk_uf1,
                                      ag_stkl
                                  )
                              )
                         FROM auftg
                        WHERE ag_rahmen_ag_id = _agid_rahmen
                          AND NOT ag_storno
                     );

       -- weniger als 0 gibts nicht
       RETURN greatest( (  coalesce(_auftgrahmen.agstkuf1, 0)
                         - coalesce(_auftgstk, 0)
                         )
                        ,
                        0
                       );
     END $$ LANGUAGE plpgsql STABLE RETURNS NULL ON NULL INPUT;
 CREATE OR REPLACE FUNCTION z_99_deprecated.rahmen_stk_auftg_offen(
     IN _agid_rahmen integer
     )
     RETURNS numeric
     AS $$
        SELECT * FROM tauftg.auftgr__rahmen_info__stko_offen__by__ag_id__get(_agid_rahmen);
     $$ LANGUAGE sql STABLE;

 -- gelieferte Menge des Rahmenauftrags zur Berechnung ag_stkl von Rahmenposition

 -- SELECT tsystem.function__drop_by_regex('tauftg.auftgr__rahmen_info__stkl__by__ag_id__get', _commit => true);
 CREATE OR REPLACE FUNCTION tauftg.auftgr__rahmen_info__stkl__by__ag_id__get(
      IN _agid_rahmen integer
      )
      RETURNS numeric
      AS $$
      BEGIN
        RETURN coalesce( sum(ag_stkl), 0)
          FROM auftg
         WHERE ag_rahmen_ag_id = _agid_rahmen
           AND NOT ag_storno
           AND     ag_stk_uf1 > 0
           AND     ag_stkl > 0;
      END $$ LANGUAGE plpgsql STABLE RETURNS NULL ON NULL INPUT;
 CREATE OR REPLACE FUNCTION z_99_deprecated.rahmen_stk_auftg_liefer(
      IN _agid_rahmen integer
      )
      RETURNS numeric
      AS $$
          SELECT * FROM tauftg.auftgr__rahmen_info__stkl__by__ag_id__get(_agid_rahmen);
      $$ LANGUAGE sql STABLE;

 -- Gesamte Rahmeninfos zum Rahmen mit der agid
 -- Verwendung in Oberfläche // bei Verwendung mit Pos Rahmen COALESCE(ag_rahmen_ag_id, ag_id)
 /* SELECT tsystem.function__drop_by_regex(
      _functionname_regex => 'auftgr__rahmen_info__data__by__ag_id__get',
      _namespace_regex => 'tauftg',
      _commit => true);
 */
 CREATE OR REPLACE FUNCTION tauftg.auftgr__rahmen_info__data__by__ag_id__get(
      IN  _agid        integer,
      OUT ag_r_agastat varchar,
      OUT ag_r_agnr    varchar,
      OUT ag_r_agpos   integer,
      OUT ag_r_aknr    varchar,
      OUT ag_r_stk     numeric,
      OUT ag_r_stko    numeric,
      OUT ag_r_stkl    numeric,
      OUT ag_r_agbda   varchar
      )
      RETURNS record
      AS $$

        SELECT ag_astat   AS ag_r_agastat,
               ag_nr      AS ag_r_agnr,
               ag_pos     AS ag_r_agpos,
               ag_aknr    AS ag_r_aknr,
               ag_stk_uf1 AS ag_r_stk,
               coalesce(tauftg.auftgr__rahmen_info__stko_offen__by__ag_id__get(ag_id), 0) AS ag_r_stko,
               coalesce(ag_stkl, 0) AS ag_r_stkl,
               ag_bda     AS ag_r_agbda
          FROM auftg
         WHERE ag_id = _agid
           AND EXISTS(SELECT true
                        FROM auftg
                       WHERE ag_id = _agid
                         AND (    ag_astat = 'R'
                              OR (ag_astat = 'E' AND ag_pos = 0)
                              )
                      );

      $$ LANGUAGE sql STABLE PARALLEL SAFE RETURNS NULL ON NULL INPUT;

 /* SELECT tsystem.function__drop_by_regex(
      _functionname_regex => 'get_rahmenInfo_auftg',
      _namespace_regex => 'z_99_deprecated',
      _commit => true);
 */
 CREATE OR REPLACE FUNCTION z_99_deprecated.get_rahmenInfo_auftg(
      IN  _agid        integer,
      OUT ag_r_agastat varchar,
      OUT ag_r_agnr    varchar,
      OUT ag_r_agpos   integer,
      OUT ag_r_aknr    varchar,
      OUT ag_r_stk     numeric,
      OUT ag_r_stko    numeric,
      OUT ag_r_stkl    numeric,
      OUT ag_r_agbda   varchar
      )
      RETURNS record
      AS $$
         SELECT * FROM tauftg.auftgr__rahmen_info__data__by__ag_id__get(_agid)
      $$ LANGUAGE sql STABLE PARALLEL SAFE;

 -- Gesamte Rahmeninfos zum Rahmen mit ak_nr -> Summiert die Stückzahlen aller Rahmen zum Artikel; optional mit Kundenbezug
 -- SELECT tsystem.function__drop_by_regex('tauftg.auftgr__rahmen_info__data__by__ak_nr__get', _commit => true);
 CREATE OR REPLACE FUNCTION tauftg.auftgr__rahmen_info__data__by__ak_nr__get(
      IN  _aknr   varchar,
      IN  _aglkn  varchar DEFAULT NULL,
      OUT r_stk   numeric,
      OUT r_stko  numeric,
      OUT r_stkl  numeric
      )
      RETURNS record
      AS $$
      BEGIN
        SELECT sum( ag_stk_uf1 ),
               sum( coalesce(tauftg.rahmen__info__stko__by__ag_rahmen_ag_id__get(ag_id), 0) ),
               sum( coalesce(ag_stkl, 0) )
          INTO r_stk,
               r_stko,
               r_stkl
          FROM auftg
         WHERE ag_aknr = _aknr
           AND (    ag_astat = 'R'
                OR (ag_astat = 'E' AND ag_pos = 0)
                )
           AND NOT ag_done
           AND ifthen(_aglkn IS NOT NULL, ag_lkn = _aglkn, true);
        --
        RETURN;
      END $$ LANGUAGE plpgsql STABLE;
 CREATE OR REPLACE FUNCTION z_99_deprecated.get_rahmenInfo_art(
      IN  _aknr   varchar,
      IN  _aglkn  varchar DEFAULT NULL,
      OUT r_stk   numeric,
      OUT r_stko  numeric,
      OUT r_stkl  numeric
      )
      RETURNS     record
      AS $$
          SELECT * FROM tauftg.auftgr__rahmen_info__data__by__ak_nr__get(_aknr, _aglkn);
      $$ LANGUAGE sql STABLE;

-- Funktion zum Ermitteln, ob die erforderliche Mindestemenge zu Rahmenaufträgen noch nicht geliefert ist
-- wenn Mindestmenge unterschritten : Rückgabe true -- IN ist ag_rahmen_ag_id
-- Aus Performancegründen mit zusätzlichen Parametern, weitere Optimierung durch Ersetzen von tauftg.auftgr__rahmen_info__data__by__ag_id__get möglich
CREATE OR REPLACE FUNCTION rahmen_minmenge(rahmenagid INTEGER, aknr VARCHAR, aglkn VARCHAR) RETURNS BOOLEAN AS $$
  DECLARE rec RECORD;
          rahmen_infos RECORD;
          minmengeproz NUMERIC;
          multirahmen INTEGER;
  BEGIN
    SELECT az_minmenge, az_minmengeproz, ain_minmenge, ain_minmengeproz
    INTO rec
    FROM art
      LEFT JOIN artinfo ON ain_ak_nr = ak_nr
      LEFT JOIN artzuo ON az_id = (SELECT az_id FROM artzuo WHERE az_prokrz = aglkn AND az_pronr = aknr ORDER BY az_gdatum DESC LIMIT 1)
    WHERE ak_nr = aknr;

    -- es gibt einen Kundenbezug
    IF COALESCE(rec.az_minmenge, rec.az_minmengeproz) IS NOT NULL THEN
        SELECT ag_r_stk, ag_r_stko INTO rahmen_infos FROM tauftg.auftgr__rahmen_info__data__by__ag_id__get(rahmenagid);

        multirahmen:= (SELECT count(ag_nr) FROM auftg WHERE ag_aknr = aknr AND (ag_pos = '0' OR ag_astat = 'R') AND NOT ag_done AND ag_lkn = aglkn);
        minmengeproz:= rec.az_minmengeproz * rahmen_infos.ag_r_stk/100;

        -- es gibt nur einen Rahmenauftrag, daher beziehen wir uns auf genau diesen Rahmen (Artikel und Kundenbezug)
        IF rahmen_infos.ag_r_stko <= COALESCE(rec.az_minmenge, minmengeproz) AND multirahmen = 1 THEN
            RETURN true;
        END IF;
        -- es gibt mehr als einen Rahmenauftrag, daher summieren wir diese Rahmen (Artikel und Kundenbezug)
        IF (tauftg.auftgr__rahmen_info__data__by__ak_nr__get(aknr, aglkn)).r_stko <= COALESCE(rec.az_minmenge, minmengeproz) AND multirahmen > 1 THEN
            RETURN true;
        END IF;
    END IF;

    -- wir rechnen die Menge aller Rahmen zum Artikel ohne Kundenbezug
    IF COALESCE(rec.ain_minmenge, rec.ain_minmengeproz) IS NOT NULL THEN
        rahmen_infos:= NULL;
        SELECT r_stk, r_stko INTO rahmen_infos FROM tauftg.auftgr__rahmen_info__data__by__ak_nr__get(aknr);

        minmengeproz:= rec.ain_minmengeproz * rahmen_infos.r_stk/100;
        IF rahmen_infos.r_stko <= COALESCE(rec.ain_minmenge, minmengeproz) THEN
            RETURN true;
        ELSE
            RETURN false;
        END IF;
    END IF;

    -- Es hat noch kein Return getroffen
    RETURN false;
  END $$ LANGUAGE plpgsql STABLE STRICT;
--

 -- Gibt Rahmen und Preis für Kunde, Artikel bzw. Auftragsnummer aus
 -- Abweichende Artikelnr. für Optionsrahmen wird ausgegeben
 -- Verwendung in Oberfläche
 CREATE OR REPLACE FUNCTION checkrahmen_auftg(
    IN  krz         varchar,
    IN  aknr        varchar,
    IN  agnr        varchar,
    OUT _rahmen_ag_id integer,
    OUT _preis      numeric,
    OUT _rabatt     numeric,
    OUT _aknr       varchar,
    OUT _mgc        integer,
    OUT _diffaknr   boolean,
    OUT _has_abzu   boolean
    )
    RETURNS RECORD
    AS $$
    BEGIN
       -- Wenn Auftragsnummer leer ist, dann dürfen Adresse und Artikel nicht leer sein.
       IF coalesce(agnr,'') = '' AND NOT (coalesce(krz,'') <> '' AND coalesce(aknr,'') <> '') THEN
            RETURN;
       END IF;

       -- Position 0 des Auftrags bevorzugen
       -- Abweichende Artikelnr. anzeigen (_diffaknr). (Funktion früher in Oberfläche über ag_rahmen)
       IF EXISTS(SELECT true FROM auftg WHERE ag_astat = 'E' AND ag_pos = 0 AND ag_nr = agnr AND (NOT ag_done OR NOT ag_storno)) THEN
            SELECT ag_id, ag_vkp, ag_arab, ag_aknr, ag_mcv, coalesce(aknr, ag_aknr) <> ag_aknr, EXISTS(SELECT true FROM auftgabzu WHERE az_ag_id = ag_id)
              INTO _rahmen_ag_id, _preis, _rabatt, _aknr, _mgc, _diffaknr, _has_abzu
              FROM auftg
             WHERE ag_pos = 0 AND ag_nr = agnr;
            RETURN;
       END IF;

       -- Ältester Rahmen anhand Kunde und Artikel
       SELECT ag_id, ag_vkp, ag_arab, ag_aknr, ag_mcv, false, EXISTS(SELECT true FROM auftgabzu WHERE az_ag_id = ag_id)
         INTO _rahmen_ag_id, _preis, _rabatt, _aknr, _mgc, _diffaknr, _has_abzu
         FROM auftg
        WHERE (ag_astat = 'R' OR (ag_astat = 'E' AND ag_pos = 0))
          AND NOT ag_done AND NOT ag_storno
          AND ag_lkn = krz
          AND ag_aknr = aknr
        ORDER BY coalesce(ag_ldatum, ag_kdatum, termweek_to_date(ag_twa)) LIMIT 1;

       RETURN;
    END $$ LANGUAGE plpgsql STABLE; --ACHTUNG: aknr wird NULL übergeben, wenn diese vom Benutzer noch nicht eingegeben wurde
 --



------------------------------------------------------
--Verkaufspreis für Artikel, Kundenklasse, Menge holen
CREATE OR REPLACE FUNCTION artikel_vkppreis(
      aknr                      varchar,
      kukrz                     varchar,
      kukl                      integer,
      menge                     numeric,
      waco                      varchar,
      _kurs                     numeric,
      meuf                      numeric,
      _preisgdatum              date = current_date,

      OUT vkpursprung           varchar,
      OUT vkpinvalid            varchar,
      OUT vkp_dbrid             varchar,
      OUT vkp                   numeric,
      OUT rab                   numeric,
      OUT astpfixpreis          boolean,
      OUT astpfixpreis_psch_mgc integer
  )
  AS $$
  DECLARE
      r            record;
      _kukl        integer;
      tmpartzuo    record;
      tmpstp       record;
      tmpkukl      record;
      chkkkl       integer;

      -- Gültigkeitsdatum: ich mache ein Angebot für nächstes Jahr.
        -- ACHTUNG: Delphi- Funktion TAuftg.GetVkp muss angepasst werden,
        -- wenn neue Datum-Abhängig Preissuchen aufgebaut werden. Siehe Kommentierung Delphi
      preisgdatum  date;

      -- umgesetzter Kurs: je nach gefundenen Währung den Eingangskurs berücksichtigen
      kurs         numeric(10,4);
  BEGIN

      IF coalesce( waco, '' ) = '' THEN
          waco := TSystem.Settings__Get( 'BASIS_W' );
      END IF;

      preisgdatum := coalesce( _preisgdatum, current_date );

      -- Keine Kundenklasse reingegeben => Kundenklasse aus Adresse holen (Kudenklasse kann im Verkauf abweichend der Adresse überschrieben werden)
      IF kukl IS null THEN
         _kukl := ad_vpber FROM adressen_view JOIN adk ON adk_ad_krz = adk.ad_krz WHERE adressen_view.ad_krz = kukrz;
      ELSE
         _kukl := kukl;
      END IF;
      --
      SELECT ak_nr, ak_canrabatt, ak_hest, ak_vkpbas, ak_vkpbasfix, ak_pknr, dbrid
        INTO r
        FROM art
       WHERE ak_nr = aknr;

      -- wenn Rabattfähig, dann Rabattstaffelsatz holen!
      IF r.ak_canrabatt THEN

          SELECT coalesce( rab_prozent, 0 )
            INTO rab
            FROM artrab
           WHERE rab_aknr = aknr
             AND coalesce( rab_kukl, _kukl, -1 ) = coalesce( _kukl, -1 )
             AND rab_menge <= menge
           ORDER BY rab_menge DESC
           LIMIT 1;

          -- NIRSCHL: EVTL EINSTELLBAR MACHEN!!!!!
          -- Rabatt wird immer aus Verkaufpreisschema gezogen
          -- Verwendung mit "Preis immer aus KuKl", im Artikel fester Preis => im Auftrag fester Grundpreis mit Positionsrabatten
          -- Damit ProzentFeld schon vorbelegt
          IF NOT found AND TSystem.Settings__GetBool( 'CheckVPBTRabatt' ) THEN

              SELECT coalesce( abs( vp_proz ), 0 )
                INTO rab
                FROM vpbt
               WHERE vp_kukl = coalesce( _kukl, -1 )
                 AND vp_prkl = r.ak_pknr
              ;

          END IF;

      END IF;

      rab          := coalesce( rab, 0 );
      vkpinvalid   := '';
      astpfixpreis := false;

      -- 1. Kunden-Festpreis (artzuo)
      -- Preis holen sortiert nach passenden zum Termin
      SELECT az_kupr, az_bisdatum, az_gdatum, az_waco, dbrid
        INTO tmpartzuo
        FROM artzuo
       WHERE az_pronr = aknr
         AND az_prokrz = kukrz
             -- Kundenzuordnung ansonsten nur für Kundenartikelnummer. Ohne Preis heißt Standard-Preissuche
         AND az_kupr IS NOT null
       ORDER BY
             coalesce( az_gdatum, preisgdatum ) <= preisgdatum DESC,
             az_gdatum DESC,
             az_bisdatum DESC
       LIMIT 1;

      -- Preis ist gültig und liegt im Datumsbereich
      IF
             tmpartzuo.az_kupr IS NOT null
         AND coalesce( tmpartzuo.az_gdatum, current_date ) <= preisgdatum
         AND coalesce( tmpartzuo.az_bisdatum, preisgdatum ) >= preisgdatum
      THEN

          rab := 0;
          vkpursprung := 'artzuo';
          vkp_dbrid   := tmpartzuo.dbrid;

          -- Währungskurs
          IF tmpartzuo.az_waco = waco THEN
             kurs := 1;
          ELSE
             kurs := _kurs;
          END IF;
          --
          vkp := tmpartzuo.az_kupr / do1If0( kurs ) / do1If0( meuf );

          RETURN;
      END IF;

      -- Preis gefunden, aber außerhalb der Gültigkeit Datum
      IF
            tmpartzuo.az_kupr IS NOT NULL
        AND (
                 coalesce( tmpartzuo.az_gdatum, current_date ) > preisgdatum
              OR (
                       tmpartzuo.az_bisdatum IS NOT NULL
                   AND coalesce( tmpartzuo.az_bisdatum, preisgdatum ) < preisgdatum
                 )
            )
      THEN

          vkpinvalid  := 'artzuo_invalid';
      END IF;
      --

      -- 2. Festpreis
      IF r.ak_vkpbasfix IS NOT NULL THEN

          vkpursprung := 'ak_vkpbasfix';
          vkp_dbrid   := r.dbrid;

          -- Fixpreis hat (noch) keine Währung
          kurs        := _kurs;
          vkp         := r.ak_vkpbasfix / do1If0( kurs ) / do1If0( meuf );

          RETURN;
      END IF;
      --

      -- 3. Staffelpreis für Kundenklasse vorhanden, höchste/ähnlichste Menge suchen
      SELECT astp_vkp, astp_fixpreis, astp_kukl, astp_waco, dbrid
        INTO tmpstp
        FROM artstp
       WHERE astp_aknr = aknr
         AND astp_menge <= menge
         AND preisgdatum BETWEEN coalesce( astp_datgv, preisgdatum ) AND coalesce( astp_datgb, preisgdatum )   --- #11687
             -- Kundenklasse passt exakt ODER Staffel hat keine Kundenklasse und ist somit für alle => beachte ORDER BY LIMIT
         AND (
                  astp_kukl IS NULL
               OR astp_kukl = _kukl
             )
       ORDER BY
             astp_menge DESC,
             astp_kukl NULLS LAST
       LIMIT 1;
       --

       -- wir haben eine exakte übereinstimmung, staffelpreis für Kundenklasse->nehmen!
      IF coalesce( tmpstp.astp_kukl, -1 ) > 0 THEN

          IF tmpstp.astp_fixpreis THEN

              astpfixpreis_psch_mgc := tartikel.me__art__artmgc__m_id__by__me_iso( aknr, 'psch' );
              astpfixpreis := true;
          END IF;
          --
          vkpursprung := 'artstp_kukl';
          vkp_dbrid   := tmpstp.dbrid;

          IF tmpstp.astp_waco = waco THEN
              kurs := 1;
          ELSE
              --Währungskurs
              kurs := _kurs;
          END IF;
          --
          vkp := round( tmpstp.astp_vkp / do1If0( kurs ) / do1If0( meuf ), 2 );

          RETURN;
      END IF;

      -- Verkaufspreis immer aus KuKl
      IF trim( TSystem.Settings__Get( 'ag_vkp_kukl' ) ) = '' THEN
          chkkkl := _kukl;
      ELSE
          chkkkl := TSystem.Settings__Get( 'ag_vkp_kukl' )::integer;
      END IF;
      --

      -- 4. Kundenklassenpreis suchen; Setting "Immer Kundenklasse X nehmen" berücksichtigen (zB Katalogpreis und Rabatt)
      SELECT vkp_vkp, vkp_waco, vkp_bisdat, vkp_vondat, dbrid
        INTO tmpkukl
        FROM artvkp
       WHERE vkp_aknr = aknr
         AND vkp_kukl IS NOT DISTINCT FROM chkkkl
       ORDER BY
             coalesce( vkp_vondat, current_date ) <= preisgdatum DESC,
             vkp_vondat DESC,
             vkp_bisdat DESC
       LIMIT 1;
      --

      -- 4.1 Verkaufspreis für genaue Kundenklasse gefunden
      IF
             tmpkukl.vkp_vkp IS NOT NULL
         AND coalesce( tmpkukl.vkp_vondat, current_date ) <= preisgdatum
         AND coalesce( tmpkukl.vkp_bisdat, preisgdatum, preisgdatum ) >= preisgdatum
      THEN
          vkpursprung := 'artvkp';
          vkp_dbrid   := tmpkukl.dbrid;

          IF tmpkukl.vkp_waco = waco THEN
              kurs := 1;
          ELSE
             -- Währungskurs
             kurs := _kurs;
          END IF;
          --
          vkp := tmpkukl.vkp_vkp / do1If0( kurs ) / do1If0( meuf );
          --

          RETURN;
      END IF;

      --
      IF
            tmpkukl.vkp_vkp IS NOT NULL
        AND (
                 coalesce( tmpkukl.vkp_vondat, current_date ) > preisgdatum
              OR (
                       tmpkukl.vkp_bisdat IS NOT NULL
                   AND coalesce( tmpkukl.vkp_bisdat, preisgdatum ) < preisgdatum
                 )
            )
      THEN
          vkpinvalid := 'artvkp_invalid' || ifthen( vkpinvalid <> '', ' -> ', '' ) || vkpinvalid;
      END IF;
      --

      -- 4.2. -> 3. Staffelpreis ohne Kundenklasse
      IF
              tmpstp.astp_kukl IS NULL
          AND tmpstp.astp_vkp IS NOT NULL
      THEN

          IF tmpstp.astp_fixpreis THEN

              astpfixpreis_psch_mgc := tartikel.me__art__artmgc__m_id__by__me_iso( aknr, 'psch' );
              astpfixpreis := true;
          ELSE

              astpfixpreis := false;
          END IF;

          vkpursprung := 'artstp_without_kukl';
          vkp_dbrid   := tmpstp.dbrid;

          -- Währungskurs
          IF tmpstp.astp_waco = waco THEN
              kurs := 1;
          ELSE
              kurs := _kurs;
          END IF;

          vkp := round( tmpstp.astp_vkp / do1If0( kurs ) / do1If0( meuf ), 2 );

          RETURN;
      END IF;


      vkp := null;

      -- 5. Verkauspreisbasis
      IF    nullif(r.ak_vkpbas, 0) IS NOT NULL THEN
            vkp := r.ak_vkpbas;
            vkpursprung := 'ak_vkpbas';
      ELSIF nullif(r.ak_hest, 0) IS NOT NULL THEN
      -- 6. Selbstkosten
            vkp := r.ak_hest;
            vkpursprung := 'ak_hest';
      END IF;

      -- Preis zurückgeben
      IF nullif(vkp, 0) IS NOT NULL THEN

          vkp_dbrid   := r.dbrid;

          -- Preis hat (noch) keine Währung
          kurs := _kurs;
          vkp  := round( vkp / do1If0( kurs ) / do1If0( meuf ), TSystem.Settings__GetInteger('NKStellen') );

          RETURN;

      END IF;
      --

      vkpursprung := 'no_art_vkp';
      vkp         := 0;
      --
      RETURN;

  END $$ LANGUAGE plpgsql STABLE;
--

-- Wrapper für Prodatversion ohne Aufruf mit Währung
CREATE OR REPLACE FUNCTION artikel_vkppreis(aknr VARCHAR(50), kukrz VARCHAR(30), kukl INTEGER, menge NUMERIC(16,4), _kurs NUMERIC(10,4), meuf NUMERIC(12,4), _preisgdatum DATE DEFAULT current_date, OUT vkpursprung VARCHAR(100), OUT vkpinvalid VARCHAR(100), OUT vkp NUMERIC(16,4), OUT rab NUMERIC(5,2), OUT astpfixpreis BOOL, OUT astpfixpreis_psch_mgc INTEGER) AS $$
  BEGIN
    SELECT (artikel_vkppreis(aknr, kukrz, kukl, menge, TSystem.Settings__Get('BASIS_W'), _kurs, meuf, _preisgdatum)).* INTO vkpursprung, vkpinvalid, vkp, rab, astpfixpreis, astpfixpreis_psch_mgc;
    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--


 ------------------------------------------------------

 CREATE OR REPLACE FUNCTION auftg_year_month_sum(IN year VARCHAR,IN kunde VARCHAR, OUT monat VARCHAR, OUT wert NUMERIC(12,2), OUT wert_erledigt NUMERIC(12,2), OUT werteing NUMERIC(12,2), OUT werteing_erledigt NUMERIC(12,2), OUT werteing_abrufe NUMERIC(12,2), OUT wertang NUMERIC(12,2), OUT wertfakt NUMERIC(12,2)) RETURNS SETOF RECORD AS $$
     DECLARE i INTEGER;
             ym VARCHAR;
             k VARCHAR;
     BEGIN
      FOR i IN 1..12 LOOP
            IF i<10 THEN
                    ym:='0'||i;
            ELSE
                    ym:=i;
            END IF;
            monat:=ym;
            k:=kunde;
            If (K IS NULL)OR(k='#') THEN--keine Adresse oder intern bedeutet gesamtsumme
                    K:='%';
            END IF;
            SELECT sum(auftg_pos_wert_basis_w(ag_id)), sum(auftg_pos_wert_basis_w(ag_id))-sum(auftg_pos_wert_offen_basis_w(ag_id)) INTO wert, wert_erledigt FROM auftg WHERE NOT ag_nstatistik AND ag_astat='E' AND ag_pos>0 AND NOT ag_storno AND CASE WHEN K='%' THEN true ELSE ag_lkn = k END AND date_to_yearmonth(ag_ldatum)=CAST(year||ym AS INTEGER) GROUP BY date_to_yearmonth(ag_ldatum) ORDER BY date_to_yearmonth(ag_ldatum);
            SELECT sum(auftg_pos_wert_basis_w(ag_id)), sum(auftg_pos_wert_basis_w(ag_id))-sum(auftg_pos_wert_offen_basis_w(ag_id)) INTO werteing, werteing_erledigt FROM auftg WHERE NOT ag_nstatistik AND ag_astat='E' AND ag_rahmen_ag_id IS NULL AND NOT ag_storno AND CASE WHEN K='%' THEN true ELSE ag_lkn = k END AND date_to_yearmonth(ag_datum)=CAST(year||ym AS INTEGER) GROUP BY date_to_yearmonth(ag_datum) ORDER BY date_to_yearmonth(ag_datum);
            SELECT sum(auftg_pos_wert_basis_w(ag_id)) INTO werteing_abrufe FROM auftg WHERE NOT ag_nstatistik AND ag_astat='E' AND ag_pos>0 AND NOT ag_storno AND CASE WHEN K='%' THEN true ELSE ag_lkn = k END AND date_to_yearmonth(ag_datum)=CAST(year||ym AS INTEGER) GROUP BY date_to_yearmonth(ag_datum) ORDER BY date_to_yearmonth(ag_datum);
            SELECT sum(auftg_pos_wert_basis_w(ag_id)) INTO wertang FROM auftg WHERE ag_astat='A' AND ag_pos>0 AND CASE WHEN K='%' THEN true ELSE ag_lkn = k END AND date_to_yearmonth(ag_datum)=CAST(year||ym AS INTEGER) GROUP BY date_to_yearmonth(ag_datum) ORDER BY date_to_yearmonth(ag_datum);
            SELECT sum(IFTHEN(be_prof='G', -1, 1)*be_gesamt_net_basis_w-bel_abschlagrechbetrag_basis_w(be_bnr, False)) INTO wertfakt FROM belkopf JOIN adressen_view AS adkv ON ad_krz=be_rkrz WHERE CASE WHEN K='%' THEN true ELSE adk_ad_krz = k END AND be_prof IN ('R', 'G', 'T') AND date_to_yearmonth(be_bdat)=CAST(year||ym AS INTEGER) GROUP BY date_to_yearmonth(be_bdat) ORDER BY date_to_yearmonth(be_bdat);
            RETURN NEXT;
      END LOOP;
      RETURN;
     END $$ LANGUAGE plpgsql;

 ----- letzte Lieferscheinnummer und Datum zum Auftrag
 CREATE OR REPLACE FUNCTION lastlifschauftg(IN agid INTEGER, OUT ldokunr VARCHAR, OUT insertdate DATE) AS $$
     BEGIN
      SELECT beld_dokunr, beld_erstelldatum INTO ldokunr, insertdate FROM lieferschein JOIN lieferschein_pos ON beld_id = belp_dokument_id WHERE belp_ag_id=agid ORDER BY beld_dokunr DESC LIMIT 1;
      RETURN;
     END $$ LANGUAGE plpgsql STABLE;


 --Alle Unterpositionen (ag_id)
 CREATE OR REPLACE FUNCTION auftg_do_auftgsubpos(agid INTEGER, stopifvkptotalpos BOOL) RETURNS SETOF INTEGER AS $$
     DECLARE r  RECORD;
             r1 RECORD;
             r2 RECORD;
     BEGIN
      SELECT ag_astat, ag_nr, ag_pos, ag_hpos INTO r FROM auftg WHERE ag_id=agid;
      FOR r1 IN SELECT ag_id, ag_vkptotalpos FROM auftg WHERE ag_astat=r.ag_astat AND ag_nr=r.ag_nr AND ag_hpos=r.ag_pos LOOP
            RETURN NEXT r1.ag_id;
            IF stopifvkptotalpos AND r1.ag_vkptotalpos THEN
            ELSE
                    FOR r2 IN SELECT * FROM auftg_do_auftgsubpos(r1.ag_id, stopifvkptotalpos) LOOP
                            RETURN NEXT r2.auftg_do_auftgsubpos;
                    END LOOP;
            END IF;
      END LOOP;
      RETURN;
     END $$ LANGUAGE plpgsql;


 --vkptotalpos: gibt nur dann die position zurück, wenn diese eine totalposition ist.
CREATE OR REPLACE FUNCTION auftg_get_auftgmainpos(
  _auftg_id                                integer,
  _suche_nichtwerthaltigen_parent          boolean = false,
  _suche_obersten_nichtwerthaltigen_parent boolean = false )
  RETURNS INTEGER AS $$
 DECLARE
    _current_auftg_record Record;
    _parent_auftg_record Record;
  BEGIN

    IF ( _suche_nichtwerthaltigen_parent IS FALSE and _suche_obersten_nichtwerthaltigen_parent IS TRUE ) THEN
      raise exception 'illegal flag combination';
    END IF;

    SELECT * INTO _current_auftg_record FROM auftg WHERE ag_id = _auftg_id;

    IF ( _current_auftg_record.ag_hpos IS NULL ) THEN
      return null;
    END IF;

    -- parent record auslesen
    SELECT * INTO _parent_auftg_record FROM auftg
                                   WHERE
                                        ag_astat = _current_auftg_record.ag_astat
                                    AND ag_nr    = _current_auftg_record.ag_nr
                                    AND ag_pos   = _current_auftg_record.ag_hpos;


    IF NOT FOUND THEN

      -- der foreignkey constraint wurde durch abgeschaltene trigger umgang und der datenzustand
      -- ist nicht konsistent, daher 23503 »foreign_key_violation«
      raise exception 'parent_non_existent' USING ERRCODE = 23503;

    END IF;

    --  entspricht ag_vkptotalpos = true
    IF ( _suche_nichtwerthaltigen_parent IS FALSE ) THEN
      RETURN _parent_auftg_record.ag_id;
    END IF;

    IF ( _suche_obersten_nichtwerthaltigen_parent ) THEN

      -- über mir kein nicht werthaltiger parent mehr existent
      -- dann bin ich die höchste nicht werthaltige position
      IF ( _parent_auftg_record.ag_vkptotalpos and auftg_get_auftgmainpos( _parent_auftg_record.ag_id, _suche_nichtwerthaltigen_parent ) IS NULL ) THEN
        RETURN _parent_auftg_record.ag_id;
      END IF;

      -- suche weiter oben weiter
      RETURN
        auftg_get_auftgmainpos(
            _parent_auftg_record.ag_id,
            _suche_nichtwerthaltigen_parent,
            _suche_obersten_nichtwerthaltigen_parent
        );

    END IF;

    -- _current_parent ist bereits der werthaltige parent, den wir suchen
    IF ( _suche_nichtwerthaltigen_parent AND _parent_auftg_record.ag_vkptotalpos IS TRUE ) THEN
      RETURN _parent_auftg_record.ag_id;
    END IF;

    -- wir suchen weiter oben nach werthaltigen parent
    IF ( _suche_nichtwerthaltigen_parent AND _parent_auftg_record.ag_vkptotalpos IS FALSE ) THEN
      RETURN auftg_get_auftgmainpos( _parent_auftg_record.ag_id, _suche_nichtwerthaltigen_parent );
    END IF;

 END $$ LANGUAGE plpgsql STABLE;


CREATE OR REPLACE FUNCTION auftg_get_mainpos(
  _current_auftg_record                    auftg,
  _suche_nichtwerthaltigen_parent          boolean = false,
  _suche_obersten_nichtwerthaltigen_parent boolean = false )
RETURNS INTEGER AS $$
  DECLARE p_rec Record;
          r Record;
  BEGIN
    -- Beachte Old/New. Im Falle Delete bzw. Änderung gibt es den aktuellen record nicht mehr, daher gehen wir vom übergebenen aus und suchen entsprechend den übergeordneten
    SELECT ag_id, ag_vkptotalpos, ag_hpos INTO p_rec FROM auftg
                                   WHERE
                                        ag_astat = _current_auftg_record.ag_astat
                                    AND ag_nr    = _current_auftg_record.ag_nr
                                    AND ag_pos   = _current_auftg_record.ag_hpos;
    --
    -- Bevor wir in Rekursion einsteigen, müssen wir hier direkt prüfen, da die nächste Funktion direkt wieder eine Ebene drüber prüft. Fällt mit neuer Belegstruktur alles weg, daher Spghetticode belassen (p_parent_p_id)
    --
    IF _suche_nichtwerthaltigen_parent = FALSE -- Einfach übergeordnetes raus, illegal Flag combination in Rekurstionsfunktion geprüft
      OR
       (_suche_nichtwerthaltigen_parent AND (NOT _suche_obersten_nichtwerthaltigen_parent OR p_rec.ag_hpos IS NULL) AND p_rec.ag_vkptotalpos) -- Drüberliegender ist VkpTotalPos UND wir suchen vkptotalpos
      THEN
        RETURN p_rec.ag_id;
    END IF;
    --
    return auftg_get_auftgmainpos( p_rec.ag_id, _suche_nichtwerthaltigen_parent, _suche_obersten_nichtwerthaltigen_parent );
  END $$ LANGUAGE plpgsql STABLE;
--

-- Liefermenge zu einer Auftragsposition bis Datum oder in Zeitraum.
-- Variablenreihenfolge ist Erweiterung geschuldet.
CREATE OR REPLACE FUNCTION tauftg.ag_stkl_fromlifsch_todate(
      in_end_date DATE,
      in_agid INTEGER,
      in_begin_date DATE DEFAULT NULL
  ) RETURNS NUMERIC(12,4) AS $$
  DECLARE
      r NUMERIC(12,4);
  BEGIN

      SELECT sum( l_abgg_uf1 )
      INTO r
      FROM lifsch
      WHERE
            l_ag_id = in_agid
        AND l_ldat::DATE BETWEEN coalesce( in_begin_date, l_ldat::DATE ) AND in_end_date;

      RETURN coalesce( r, 0 );

  END $$ LANGUAGE plpgsql STABLE;
--

-- Noch zu bestellende Menge für Auftragsposition in Grundmengeneinheit (ehemals Delphi TAuftg.GetStkOpenForBest)
CREATE OR REPLACE FUNCTION TWaWi.auftg__ag_stkb__offen__calc(
    IN _agid integer,
    IN _UseVerfuegbar boolean DEFAULT null,
    IN _akverfueg numeric DEFAULT null
    )
    RETURNS numeric(12,4)
    AS $$
    BEGIN

        RETURN
          TWaWi.auftg__ag_stkb__offen__calc(
              auftg,
              _UseVerfuegbar,
              _akverfueg)
          FROM auftg
          WHERE ag_id = _agid;

    END $$ LANGUAGE plpgsql STABLE;
--

-- Noch zu bestellende Menge für Auftragsposition in Grundmengeneinheit (ehemals Delphi TAuftg.GetStkOpenForBest)
CREATE OR REPLACE FUNCTION TWaWi.auftg__ag_stkb__offen__calc(
    IN _r auftg,
    IN _UseVerfuegbar boolean DEFAULT null,
    IN _akverfueg numeric DEFAULT null
    )
    RETURNS numeric(12,4)
    AS $$
    BEGIN

        IF _akverfueg IS NULL THEN

            SELECT art.ak_verfueg
              INTO _akverfueg
              FROM art
             WHERE ak_nr = _r.ag_aknr;
        END IF;

        RETURN
        TWaWi.auftg__ag_stkb__offen__calc(
            _r,
            _akverfueg,
            _useVerfuegBar
        );

    END $$ LANGUAGE plpgsql STABLE;
--

-- Noch zu bestellende Menge für Auftragsposition in Grundmengeneinheit (ehemals Delphi TAuftg.GetStkOpenForBest)
  -- Rechnet nur auf übergebenen Werten, ohne SubSelects
CREATE OR REPLACE FUNCTION TWaWi.auftg__ag_stkb__offen__calc(
      IN _auftg auftg,
      IN _ak_verfueg numeric,
      IN _UseVerfuegbar boolean DEFAULT null
      )
      RETURNS numeric(12,4)
      AS $$
      DECLARE offen numeric(12,4);
      BEGIN

        -- Wenn nicht explizit angegeben ob Verfuegbarkeit rausgerechnet werden soll, halten wir uns an das Setting
        IF _UseVerfuegbar IS NULL THEN
           _UseVerfuegbar := TSystem.Settings__GetBool('SkipBestOn_AkVerfueg');
        END IF;

        -- Für erledigte Positionen bestellen wir nichts mehr.
        IF  _auftg.ag_done OR _auftg.ag_storno THEN
          RETURN 0;
        END IF;

        -- in der Verfügbarkeit sind wir selbst bereits runtergerechnet, daher wieder aufaddieren. Bsp: 20 Lagerbestand, nur ein Auftrag von 5. Somit sind 15 verfügbar. Da wir der einzige Auftrag sind, sind aber 20 (für mich selbst) verfügbar und nicht nur 15.
        -- Fehler tritt auf, wenn etwas mehr Lagernd als verkauft, da dann Verfügbar knapp positiv und die Vorschlagsmenge falsch macht. bsp: Verkauft 20, Lagernd 28. Somit verfügbar (nach dem Auftrag) => 8. Da positiv verfügar würden unten 20 - 8 = 12 als Menge vorgeschlagen, was falsch ist. Für den Auftrag von 20 stehen ja die vollen 28 verfügbar.
        _ak_verfueg := max(_ak_verfueg + IFTHEN(_auftg.ag_astat <> 'A' AND (_auftg.ag_astat <> 'R' OR twawi.auftg__ag_pos0defini()) , _auftg.ag_stk_uf1, 0), 0);

        -- Zu Bestellen = Auftragsmenge - Schon bestellt - Lagerreservation - Verfügbare Menge
        Offen := _auftg.ag_stk_uf1 - _auftg.ag_stkb - _auftg.ag_stkres - IfThen( _UseVerfuegbar, _ak_verfueg, 0);

        -- Offene Menge nie kleiner als 0.
        RETURN max(Offen, 0);

      END $$ LANGUAGE plpgsql STABLE;
--

-- Kundenrentabilität
CREATE OR REPLACE FUNCTION tauftg.auftg__kund_rent(
    IN _agnr VARCHAR,
    IN _aknr VARCHAR,
    IN _aglkn VARCHAR,
    IN _l_datum_von DATE,
    IN _l_datum_bis DATE,
    IN _be_datum_von DATE,
    IN _be_datum_bis DATE,
    OUT agid INTEGER,
    OUT sum_ag_nk_vkp NUMERIC,
    OUT abks text,
    OUT abk_anzahl INTEGER,
    OUT abk_menge NUMERIC,
    OUT abk_auss NUMERIC,
    OUT sum_nk_netto_basis_w NUMERIC,
    OUT nk_netto_basis_w NUMERIC,
    OUT nk_matr_basis_w NUMERIC,
    OUT sum_nk_matr_basis_w NUMERIC,
    OUT rech_nr VARCHAR,
    OUT rech_summe NUMERIC,
    OUT rech_menge NUMERIC,
    OUT rech_anzahl INTEGER,
    OUT rech_letzte VARCHAR,
    OUT rech_ldat DATE,
    OUT rech_zugeordnet NUMERIC
  ) RETURNS SETOF RECORD AS $$
  DECLARE
      r_auftg            RECORD; -- Kundenauftrag
      r_nachkalk         RECORD;
      r_auftg_nk_sub_sum RECORD;
      r_rechnungen       RECORD;
      ausw_auto_vorkalk  BOOLEAN := TSystem.Settings__GetBool('AUSW_AUTO_VORKALK');
  BEGIN
    FOR r_auftg IN
        SELECT ag_id, ag_nr, ag_pos
        FROM auftg
        WHERE ag_astat = 'E'
          AND ag_q_nr IS NULL
          AND ag_nr LIKE COALESCE(_agnr, ag_nr)
          AND ag_aknr LIKE COALESCE(_aknr, ag_aknr)
          AND ag_lkn LIKE COALESCE(_aglkn, ag_lkn)
          AND (ag_datum BETWEEN COALESCE(_l_datum_von, current_date - INTERVAL '3 year') AND COALESCE(_l_datum_bis, current_date))
          AND CASE WHEN _l_datum_von IS NOT NULL AND _l_datum_bis IS NOT NULL THEN
                  ag_id IN (SELECT belp_ag_id FROM lieferschein_pos JOIN lieferschein ON belp_dokument_id = beld_id WHERE beld_erstelldatum BETWEEN _l_datum_von AND _l_datum_bis)
              ELSE true
              END
          AND CASE WHEN _be_datum_von IS NOT NULL AND _be_datum_bis IS NOT NULL THEN
                  ag_id IN (
                    SELECT ag_id
                    FROM belzeil_grund
                      JOIN belkopf ON be_bnr = bz_be_bnr
                      JOIN auftg ON ag_astat = 'E' AND ag_nr = bz_auftg AND ag_pos = bz_auftgpos
                    WHERE be_bdat BETWEEN _be_datum_von AND _be_datum_bis
                      AND be_prof IN ('R', 'G') -- nur Rechnungen und Gutschriften
                      AND NOT EXISTS(SELECT true FROM belkopf AS refd_inv WHERE refd_inv.be_bnr = bz_bz_be_bnr AND (refd_inv.be_prof = 'T' OR refd_inv.be_txba IN (4, 6, 7)) AND belkopf.be_prof = 'G') -- Gutschrift hat keinen Bezug zu Anzahlungen und Abschlägen.
                  ) -- nur Rechnungen und Gutschriften
              ELSE true
              END
          AND NOT ag_storno
        LIMIT 10000
    LOOP
        agid := r_auftg.ag_id;
        sum_ag_nk_vkp := 0;
        abks := NULL;
        abk_anzahl := 0;
        abk_menge := 0;
        abk_auss := 0;
        nk_netto_basis_w := 0;
        sum_nk_netto_basis_w := 0;
        sum_nk_matr_basis_w := 0;

        --Nachkalkulation
        FOR r_nachkalk IN

            SELECT
              ag_nk_vkp_uf1, ab_ix, ab_nk_st_uf1, ab_nk_auss, ab_nk_matr_et, ab_nk_matr_bg,
              ab_nk_fgk, ab_nk_mgk, ab_nk_agk -- Gemeinkostenzuschläge
            FROM ldsauftg
              LEFT JOIN ldsdok ON la_ld_id = ld_id
              LEFT JOIN abk ON ab_ix = ld_abk
              LEFT JOIN auftg ON ag_id = la_ag_id
            WHERE la_ag_id = r_auftg.ag_id
              AND ld_stk > 0 -- nichtpositive Bestellmenge ausfiltern
              AND NOT ab_storno
        LOOP
            sum_ag_nk_vkp := sum_ag_nk_vkp + COALESCE(r_nachkalk.ag_nk_vkp_uf1, 0);
            IF abks IS NULL THEN
                abks := r_nachkalk.ab_ix;
            ELSE
                abks := abks || ',' || r_nachkalk.ab_ix ;
            END IF;

            abk_anzahl := abk_anzahl + 1;
            abk_menge :=  abk_menge  + r_nachkalk.ab_nk_st_uf1;
            abk_auss :=   abk_auss   + r_nachkalk.ab_nk_auss;
            --Selectstatement für Berechnung: Untersummen
              SELECT
                -- EinzelPreis-wirksame Sonderkosten
                tabk.get_sonder_kosten(r_nachkalk.ab_ix) AS kost_sond,
                -- Fertigungskosten vgl. tplanterm.buchrm
                ((SELECT
                    SUM(n2_ez_stu *
                      CASE WHEN n2_ruest   THEN coalesce( kssa_stsr, nkk_nssr, ks_stsr, 0 ) -- Rüststundensatz
                           WHEN n2_pz_para THEN coalesce( kssa_stsm, nkk_nssm, ks_stsm, 0 ) -- Stundensatz für parallele Personalzeit
                           ELSE                 coalesce( kssa_sts,  nkk_nssf, ks_sts,  0 ) -- Stundensatz
                      END
                    )
                  FROM nk2
                    LEFT JOIN ab2 ON a2_ab_ix = n2_ix AND a2_n = n2_n
                    -- Sonderfall NK: Arbeitspaket-spezifischer Stundensatz (Sts) kssa_sts gilt vor NK-Sts, gilt vor KS-Sts.
                      -- Verwendung von tartikel.ksv__data__by__ks_abt__kssa_ak_nr__get nicht zielführend, da andere Hierarchie
                    JOIN ksv ON ks_abt = coalesce( n2_ks, a2_ks )
                    LEFT JOIN ksv_stundensatz_art ON kssa_ks_abt = ks_abt AND kssa_ak_nr = a2_aknr
                    LEFT JOIN nkksv ON nkk_ab_ix = n2_ix AND nkk_ks = ks_abt
                  WHERE n2_ix = r_nachkalk.ab_ix AND NOT n2_ausw AND NOT ks_notInCalc AND NOT ks_sondkost)
                  -- zzgl. Fertigungsgemeinkosten
                  * COALESCE((1 + r_nachkalk.ab_nk_fgk / 100), 1)
                ) AS kost_fertkost,
                -- Materialkosten vgl. tplanterm.buchrm
                ((SELECT
                    SUM(COALESCE(mat.ag_nk_stkl_uf1, mat.ag_stkl)
                      * COALESCE(mat.ag_nk_vkp_uf1, mat.ag_nk_calc_vkp_uf1, mat.ag_vkp_uf1)
                      -- zzgl. Materialgemeinkosten (abhängig vom Materialstatus)
                      * CASE WHEN mat.ag_post2 IN ('R', 'N') AND mat.ag_ownabk IS NULL THEN COALESCE((1 + r_nachkalk.ab_nk_mgk / 100),1) ELSE 1 END
                    )
                  FROM auftg AS mat
                  WHERE mat.ag_parentabk IN (SELECT r_nachkalk.ab_ix UNION /* Set-Artikel */ SELECT set_abk.ab_ix FROM abk AS set_abk WHERE set_abk.ab_ld_id IS NULL AND set_abk.ab_parentabk = r_nachkalk.ab_ix)
                    AND NOT TSystem.Enum_GetValue(mat.ag_stat, 'BK')) -- keine Beistellung durch Kunden, siehe #11316
                ) AS kost_mat,
                -- Materialkosten ONLY
                r_nachkalk.ab_nk_matr_bg AS kost_matroh,
                -- Auswärtskosten vgl. tplanterm.buchrm
                ((SELECT
                    CASE WHEN NOT ausw_auto_vorkalk THEN -- Setting "Vorgabewerte für Auswärts verwenden"
                        SUM(COALESCE(tplanterm.ausw_rech_gesamt(a2_id), 0)) -- Gesamte Auswärtskosten an AG ohne Vorgabewerte
                    ELSE
                        SUM(COALESCE(tplanterm.ausw_rech_gesamt(a2_id), -- Wenn noch keine Rechnung vorliegt, Vorgabe aus AVOR nehmen und verrechnen mit vergebene, rückgelieferte, verrechnete bzw. Fertigungsmenge. Identisch zu Report "Nachkalkulation"
                                     o2_awpreis * COALESCE(tplanterm.ausw_menge_rueck_rech(a2_id), -- verrechnete Menge (eigentlich unnötig, aber identisch zum report)
                                                           tplanterm.ausw_menge_rueck(a2_id),      -- rückgelieferte Menge
                                                           tplanterm.ausw_menge_send(a2_id),       -- vergebene Menge
                                                           abk.ab_st_uf1                               -- Fertigungsmenge
                                                          ),
                                     0
                                    )
                           )
                    END
                  FROM ab2
                    JOIN abk ON abk.ab_ix = a2_ab_ix
                    LEFT JOIN op2 ON o2_id = a2_o2_id
                  WHERE a2_ab_ix = r_nachkalk.ab_ix)
                  -- zzgl. Auswärtsgemeinkosten
                  * COALESCE((1 + r_nachkalk.ab_nk_agk / 100), 1)
                ) AS kost_ausw
               INTO r_auftg_nk_sub_sum;
            --
            --
            sum_nk_netto_basis_w:= sum_nk_netto_basis_w
                                    + COALESCE(r_auftg_nk_sub_sum.kost_sond,0)
                                    + COALESCE(r_auftg_nk_sub_sum.kost_fertkost,0)
                                    + COALESCE(r_auftg_nk_sub_sum.kost_mat,0)
                                    + COALESCE(r_auftg_nk_sub_sum.kost_ausw,0);
            sum_nk_matr_basis_w := sum_nk_matr_basis_w + COALESCE(r_auftg_nk_sub_sum.kost_matroh,0);
            --
            nk_netto_basis_w := sum_nk_netto_basis_w / COALESCE(NullIf(abk_menge,0) ,1);
            nk_matr_basis_w   := sum_nk_matr_basis_w / COALESCE(NullIf(abk_menge,0), 1);
        END LOOP;

        rech_nr := NULL;
        rech_summe := 0;
        rech_menge := 0;
        rech_anzahl := 0;
        rech_letzte := NULL;
        rech_ldat := NULL::DATE;

        -- Rechnungen
        FOR r_rechnungen IN
            SELECT
              bz_tot_basis_w * (IFTHEN(be_prof = 'G', -1, 1)) AS rech_summe
              , IFTHEN(be_txba = 7 /*Abschlagsrechnung, Menge nicht doppelt!*/, 0, bz_fakt_uf1) AS rech_menge
              , be_bdat
              , be_bnr
            FROM belzeil_grund
              JOIN belkopf ON be_bnr = bz_be_bnr
            WHERE bz_auftg = r_auftg.ag_nr AND bz_auftgpos = r_auftg.ag_pos
              AND be_prof IN ('R', 'G') -- nur Rechnungen und Gutschriften
              AND NOT EXISTS(SELECT true FROM belkopf AS refd_inv WHERE refd_inv.be_bnr = bz_bz_be_bnr AND (refd_inv.be_prof = 'T' OR refd_inv.be_txba IN (4, 6, 7)) AND belkopf.be_prof = 'G') -- Gutschrift hat keinen Bezug zu Anzahlungen und Abschlägen.
        LOOP
            IF rech_nr IS NULL THEN
                rech_nr := r_rechnungen.be_bnr;
            ELSE
                rech_nr := rech_nr || ',' || r_rechnungen.be_bnr;
            END IF;
            rech_summe := rech_summe + COALESCE(r_rechnungen.rech_summe, 0);
            rech_menge := rech_menge + COALESCE(r_rechnungen.rech_menge, 0);
            rech_anzahl := rech_anzahl + 1;
            IF (r_rechnungen.be_bdat > rech_ldat) OR (rech_ldat is NULL) THEN
                rech_ldat := r_rechnungen.be_bdat;
                rech_letzte := r_rechnungen.be_bnr;
            END IF;
        END LOOP;
        --
        rech_zugeordnet = COALESCE((SELECT
                                      SUM(l_abgg)
                                    FROM ldsauftg
                                      LEFT JOIN lifsch ON l_la_id = la_id
                                      --LEFT JOIN ldsdok ON la_ld_id = ld_id
                                    WHERE
                                      la_ag_id = agid), 0);
        --
        RETURN NEXT;
    END LOOP;
    --
    RETURN;
  END $$ LANGUAGE plpgsql;
--

CREATE OR REPLACE FUNCTION tauftg.ldsauftg_set(_agnr VARCHAR, _agpos INTEGER, _abk INTEGER, _loid INTEGER, _lnr INTEGER) RETURNS INTEGER AS $$
  -- Eingabe: von Nutzer in F2 ausgewählte LagerlogID
  -- Rückgabe: Zugeordnete Stückanzahl
  DECLARE
    agid INTEGER;
    ldid INTEGER;
    laid INTEGER;
    stk INTEGER;
    rest INTEGER;
    rech_menge_sum INTEGER;
    la_stk_sum INTEGER;
    zuordn_stk INTEGER;
  BEGIN
    SELECT ag_id
    FROM auftg
      LEFT JOIN ldsdok ON (ld_ag_id = ag_id) AND (ld_abk = _abk)
    WHERE (ag_nr = _agnr) AND (ag_pos = _agpos) AND (ag_astat = 'E')
    INTO agid;

    SELECT
      COALESCE(w_lds_id, l_ld_id) AS ld_id,
      l_abgg_uf1::INTEGER,
      (lo_stk_new - lo_zugeo)::INTEGER AS lo_rest
    FROM lagerlog
      LEFT JOIN ldsdok ON (ld_auftg = lo_nr) AND (ld_pos = lo_pos) AND (ld_code = lo_stat)
      LEFT JOIN lifsch ON l_nr = _lnr
      LEFT JOIN wendat ON (w_wen = lo_wendat /*LZ*/ ) OR (w_wen = l_w_wen /*LA*/ )
      JOIN LATERAL COALESCE((SELECT SUM(la_stk) FROM ldsauftg
                             LEFT JOIN ldsdok ON ld_id = la_ld_id
                             WHERE ld_abk = w_ab_ix), 0) AS lo_zugeo ON true
    WHERE lo_id = _loid
    INTO ldid, stk, rest;

    -- Wenn ldid NULL ist, neue Position anlegen?
    IF ldid IS NULL THEN
        --INSERT INTO ldsdok
        RETURN -2;
    END IF;

    -- Folgende Summen brauchen wir um Stückanzahl vorzuschlagen
    /* rech_menge_sum */
    SELECT COALESCE(sum(bz_fakt_uf1), 0)::INTEGER FROM belzeil_grund WHERE (bz_auftg = _agnr) AND (bz_auftgpos = _agpos) INTO rech_menge_sum;

    /* la_stk_sum */
    SELECT COALESCE(sum(la_stk), 0)::INTEGER FROM ldsauftg WHERE la_ag_id = agid INTO la_stk_sum;
    --

    IF la_stk_sum >= rech_menge_sum OR rech_menge_sum = 0 THEN
        -- muss man nichts mehr zuordnen
        RETURN -1;
    END IF;

    -- stk ausrechnen
    zuordn_stk:= rech_menge_sum - la_stk_sum;
    IF zuordn_stk < stk THEN
        stk:= zuordn_stk;
    END IF;

    --RAISE EXCEPTION 'ldid: %, stk: %, rest: %, (%)', ldid, stk, rest, rech_menge_sum - la_stk_sum;

    IF stk > rest THEN
        stk := rest;
    END IF;

    IF stk <= 0 THEN
        RETURN -1;
    END IF;

    -- Auftrag binden
    IF ldid IS NOT NULL AND agid IS NOT NULL THEN
      -- Wenn der Auftrag schon gebunden ist, Stückzahl ändern
      UPDATE ldsauftg SET la_stk= NULL, la_stk_uf1 = COALESCE(la_stk_uf1, 0) + stk
            WHERE la_ld_id = ldid AND la_ag_id = agid
            RETURNING la_id INTO laid;

      -- Sonnst binden
      IF NOT FOUND THEN
        INSERT INTO ldsauftg (la_ld_id, la_ag_id, la_stk_uf1, la_mce)
               VALUES (ldid, agid, stk, (SELECT ld_mce FROM ldsdok WHERE ld_id = ldid))
               RETURNING la_id INTO laid;
      END IF;
      -- und Verknüpfung setzen
      UPDATE lifsch SET l_la_id = laid WHERE l_nr = _lnr;
    END IF;

    RETURN stk;
  END $$ LANGUAGE plpgsql;
--

-- AuftragsNr zusammenfassen
 CREATE OR REPLACE FUNCTION twawi.auftg_GenConcatNr(IN r auftg) RETURNS VARCHAR(75) AS $$
   SELECT r.ag_astat||' | '||r.ag_nr||' | '||r.ag_pos;
   $$ LANGUAGE SQL STABLE;

 CREATE OR REPLACE FUNCTION twawi.auftg_GenConcatNr(IN agid INTEGER) RETURNS VARCHAR(75) AS $$
   SELECT twawi.auftg_GenConcatNr(auftg) FROM auftg WHERE ag_id = agid;
   $$ LANGUAGE SQL STABLE;
--

--
CREATE OR REPLACE FUNCTION tplanterm.artikel_prognose_from_auftg(new auftg) RETURNS BOOL AS $$
  BEGIN
    DELETE FROM bestanfpos WHERE bap_pr_ag_id=new.ag_id AND bap_prognose;
    RETURN tplanterm.artikel_prognose_from_auftrag(new.ag_aknr, new.ag_stk_uf1-numeric_larger(new.ag_stkb, new.ag_stkl), new.ag_lkn || ' ~ ' || new.ag_nr, new.ag_pos, COALESCE(new.ag_aldatum, new.ag_ldatum, new.ag_kdatum), 'PROG AE '||COALESCE(new.ag_aldatum, new.ag_ldatum, new.ag_kdatum, current_date), new.ag_id, NULL, new.ag_lkn);
  END $$ LANGUAGE plpgsql;
--

-- Deckung offener Aufträge durch direkt und indirekt verknüpfte Bestellungen
CREATE OR REPLACE FUNCTION tauftg.auftg_ldsdok_bilanz(
    VARIADIC auftragsnummern VARCHAR[], -- Angabe mehrer Auftragsnummer oder Array von Auftragsnummern möglich (tauftg.auftg_ldsdok_bilanz(VARIADIC Array_von_Auftragsnummern))
    OUT agid INTEGER,
    OUT aknr VARCHAR, -- aknr, dat werden in getBestVorschlag_Auftrag gebraucht, daher gleich holen.
    OUT dat  DATE,    -- Bedarfsdatum Auftrag
    OUT qty  NUMERIC  -- Bedarfsmenge nach Deckung, implizit NUMERIC(12,4) damit Auftragsmenge minus Bestellmenge sauber gerechnet werden kann.
  ) RETURNS SETOF RECORD AS $$
  DECLARE auftg_rec  RECORD;
          ldsdok_rec RECORD;
  BEGIN
    FOR auftg_rec IN -- Bedarfe
        -- offene Auftragspositionen (E, I)
        SELECT ag_id, ag_nr, ag_aknr, COALESCE(ag_ldatum, ag_kdatum, current_date) AS dat, (ag_stk_uf1 - ag_stkl)::NUMERIC(12,4) AS qty -- Kein -ag_stkb, da damit nur direkt verknüpfte Bestellungen enthalten sind. Unten wird Deckung über alle Bestellungen an Aufträgen ermittelt.
        FROM auftg
        WHERE ag_astat IN ('E', 'I') -- keine Angebote, Rahmen
          AND ag_nr = ANY (auftragsnummern)
          AND NOT ag_done
        ORDER BY ag_id
    LOOP
        auftg_rec.qty:= auftg_rec.qty - COALESCE((
            -- Deckung durch Bestellungen an Aufträgen
            -- Achtung m:n-Beziehung! Die Schwierigkeit ist: Welche Aufträge sind mit welchen Bestellungen erledigt bzw. mit welchen Mengen gedeckt.
            SELECT SUM(COALESCE(nullif(la_stk, 0), GREATEST(ld_stk_uf1, ld_stkl)))
            -- ggf. zug. Bestellmenge des verknüpften Auftrags (la_stk),
            -- sonst komplette Bestellmenge. Bei mehreren verknüpften Aufträgen dann nicht eindeutig zuordenbar und ggf. mehrfach verrechnet.
            FROM ldsdok
              LEFT JOIN ldsauftg ON la_ld_id = ld_id AND la_ag_id = auftg_rec.ag_id -- verknüpfter Auftrag mit spez. Menge, eindeutig per UNIQUE
            WHERE ( ld_ag_id = auftg_rec.ag_id -- Bestellungen direkt aus Aufträgen
                    OR ld_id IN (SELECT la_ld_id FROM ldsauftg WHERE la_ag_id = auftg_rec.ag_id) -- Bestellungen sind mit Aufträgen verknüpft
                    OR (ld_auftg = auftg_rec.ag_nr AND ld_aknr = auftg_rec.ag_aknr) -- freie Bestellungen mit gleicher Nr. (Artikel muss in dem Fall passen)
                  )
              AND (ld_code <> 'R' AND ld_pos > 0) -- keine Rahmen
              AND NOT ld_storno -- ld_done egal (Bestellung bedient Auftrag)
              AND NOT EXISTS(SELECT true FROM bestanfpos WHERE bap_ld_id = ld_id) -- Gedeckte Bedarfe aus BANF ignorieren.
            ), 0);

        agid:= auftg_rec.ag_id;
        aknr:= auftg_rec.ag_aknr;
        dat:=  auftg_rec.dat;
        qty:=  auftg_rec.qty;

        RETURN NEXT;
    END LOOP;
  END $$ LANGUAGE plpgsql;
--
CREATE OR REPLACE FUNCTION tauftg.lifsch__einzelpreis_gewichtet(IN in_l_nr INTEGER, IN in_ag_id INTEGER) RETURNS NUMERIC AS $$
  SELECT
    -- gewichteter Einzelpreis
    SUM(l_abgg_uf1 * COALESCE(
        erg_ep_gewichtet, -- oder aus ER (EP netto inkl. Abzu und Rabatt)
        ldsdok_ext.ld_netto_basis_w / Do1If0(ldsdok_ext.ld_stk_uf1), -- oder aus Bestellung (EP netto inkl. Abzu und Rabatt)
        ak_hest) -- Fallback auf Artikelstamm
       ) / Do1If0(SUM(l_abgg_uf1))::NUMERIC(20,8) -- gewichtet: Summe(PosMenge * PosPreis) / Gesamtmenge
    --
  FROM
    lifsch
    LEFT JOIN auftg                   ON ag_id = l_ag_id
    LEFT JOIN art                     ON ak_nr = l_aknr
    LEFT JOIN ldsdok AS ldsdok_ext    ON ld_id = l_ld_id AND ld_code = 'E'
    LEFT JOIN LATERAL ( -- ERG an Bestellung
      SELECT
        SUM(belp_netto_basis_w) / Do1If0(SUM(belp_menge_gme)) AS erg_ep_gewichtet -- gewichteter Durchschnittspreis aller Eingangsrechnungen an Bestellung
      FROM
        eingrech_pos --war von AK belegpos. Geändert DS 2020-01-02
      WHERE
        belp_ld_id = ldsdok_ext.ld_id
        AND NOT belp_storniert
    ) AS erg ON ldsdok_ext.ld_id IS NOT NULL -- ERG nur wenn Bestellung gefunden
  WHERE
    l_nr = COALESCE(in_l_nr, l_nr) -- Einstieg über LA-Nr.
    AND COALESCE(ag_id, 0) = COALESCE(in_ag_id, ag_id, 0); -- Einstieg über AuftragsPos-ID
$$ LANGUAGE sql STABLE;
--
CREATE OR REPLACE FUNCTION public.auftg__b_iu__canrabatt() RETURNS trigger
AS $$
BEGIN

  IF ( new.ag_vkptotalpos IS TRUE OR auftg_get_mainpos( new, true ) is not null) THEN

    perform PRODAT_ERROR('Zusammengesetzte Positionen unterstützen »keinen Rabatt« nicht');
    new.ag_canrabatt := true;

    RETURN new;

  END IF;

  RETURN new;

END $$ LANGUAGE plpgsql;

  CREATE TRIGGER auftg__b_iu__canrabatt
    BEFORE INSERT OR UPDATE
    OF ag_hpos, ag_canrabatt, ag_vkptotalpos
    ON auftg
    FOR EACH ROW
    WHEN ( new.ag_canrabatt IS FALSE )
    EXECUTE PROCEDURE public.auftg__b_iu__canrabatt();
--


-- komplette Auftragsstrukturen inkl. Optionen zur Bearbeitung kopieren
CREATE OR REPLACE FUNCTION tauftg.auftg__copy(
      -- Quelle
      _src_ag_id                  integer,
      _src_ag_astat               varchar,
      _src_ag_nr                  varchar,
      _src_ag_pos                 varchar,  -- mehrere Pos per LIKE

      -- Ziel
      _trg_ag_id                  integer,  -- Wenn Option Anhand aus wird diese Pos ersetzt.
      _trg_ag_astat               varchar,  -- an diese Auftragsstruktur
      _trg_ag_nr                  varchar,

      -- Optionen
      _opt_anhang                 boolean = true,   -- Option Anhang
      _opt_inkl_unterstruktur     boolean = false,  -- Option Unterstrukturen auflösen
      _opt_mit_projekt            boolean = false,  -- Option Projekt erzeugt zus. neuen Projekteintrag
      _opt_vk_preis_neu_berechnen boolean = false,  -- Option Verkauspreise neu berechnen
      _opt_ag_bdat_leeren         boolean = false,  -- Option zum Leeren des originalen Bestelldatums d. Kunden
      _opt_inkl_eigenschaften     boolean = false,  -- Option Eigenschaften/Parameter mit kopieren
      _opt_nfach_kopie            integer = 1,      -- Option Anzahl der Kopien (>=1)
      _opt_dokument               boolean = true,   -- Option mit Dokumentkopien

      -- Änderungen am Ziel
      _chg_ag_lkn                 varchar = null, -- Besteller
      _chg_ag_krzl                varchar = null, -- Lieferadresse
      _chg_ag_krzf                varchar = null, -- Rechnungsadresse
      _chg_ag_bda                 varchar = null, -- Bestellnummer d. Kunden
      _chg_ag_an_nr               varchar = null, -- Projektnummer
      _chg_ag_kukl                integer = null, -- Kundenklasse
      _chg_ag_arab                numeric = null  -- Rabatt

  ) RETURNS void AS $$
  DECLARE
      _src_ag_dokunr                      integer;
      _trg_ag_dokunr                      integer;
      _this__to_copy                      record;
      _this__to_update                    record;
      _auftg_pos__vk_preis_neu_berechnen  integer;
  BEGIN

    -- Zielfelder per ID vorbereiten, wenn unvollständig.
    IF
            _trg_ag_id IS NOT NULL
        AND (
                _trg_ag_astat IS NULL
            OR  _trg_ag_nr    IS NULL
        )

    THEN

        SELECT
            ag_astat,
            ag_nr
        FROM auftg
        WHERE ag_id = _trg_ag_id
        INTO
            _trg_ag_astat,
            _trg_ag_nr
        ;

    END IF;
    --


    -- Fehlerbehandlung
        -- kein Ziel definiert
        IF
                _trg_ag_astat IS NULL
            OR  _trg_ag_nr    IS NULL

        THEN
            RAISE EXCEPTION '%', lang_text( 16873 );
        END IF;

        -- fehlende Optionen
        IF
                _opt_anhang                 IS NULL
            OR  _opt_inkl_unterstruktur     IS NULL
            OR  _opt_mit_projekt            IS NULL
            OR  _opt_vk_preis_neu_berechnen IS NULL
            OR  _opt_ag_bdat_leeren         IS NULL
            OR  _opt_inkl_eigenschaften     IS NULL
            OR  _opt_nfach_kopie            IS NULL

        THEN
            RAISE EXCEPTION '%', lang_text( 16874 );
        END IF;

        --
        IF _opt_nfach_kopie <= 0 THEN
            RAISE EXCEPTION '%', lang_text( 16877 );
        END IF;
    --


    -- Wenn kein Anhang, dann Pos ersetzen, vgl. orig. RTF-Skript #16015
    IF NOT _opt_anhang THEN
        DELETE FROM auftg WHERE ag_id = _trg_ag_id;
    END IF;


    -- Quellen entspr. Optionen holen und vorbereiten
    CREATE TEMP TABLE auftg__copy__fetch__temp AS
        SELECT
            ag_id,
            ag_astat,
            ag_nr,
            ag_pos        AS old_ag_pos,
            null::integer AS new_ag_pos,
            ag_hpos       AS old_ag_hpos,
            null::integer AS new_ag_hpos,
            ag_dokunr     AS old_ag_dokunr,
            null::integer AS new_ag_dokunr
        FROM
            tauftg.auftg__copy__fetch(
                _src_ag_id,
                _src_ag_astat,
                _src_ag_nr,
                _src_ag_pos,

                _opt_inkl_unterstruktur
            )
        ORDER BY ag_pos
    ;


    -- Fehlerbehandlung: keine Quelle definiert
    IF  ( SELECT count(*) = 0 FROM auftg__copy__fetch__temp ) THEN
        RAISE EXCEPTION '%', lang_text( 16872 );
    END IF;


    -- mehrfache Kopie
    FOR i IN 1.._opt_nfach_kopie LOOP

        -- Initialisierung
        UPDATE auftg__copy__fetch__temp SET
            new_ag_pos  = old_ag_pos,
            new_ag_hpos = old_ag_hpos,
            new_ag_dokunr = null
        ;


        -- Gemeinsame Dokumente ermitteln.
          -- Fall: mehrere Positionen auf einem Dokument
          -- Fall: mehrere Dokumente pro Auftrag an verschiedene Pos.
        IF _opt_dokument THEN
            FOR _src_ag_dokunr IN

                SELECT
                    DISTINCT old_ag_dokunr
                FROM auftg__copy__fetch__temp
                WHERE old_ag_dokunr IS NOT NULL
                ORDER BY old_ag_dokunr

            LOOP
                _trg_ag_dokunr := twawi.auftg__ag_dokunr__new__by__astat__get( _trg_ag_astat );

                UPDATE auftg__copy__fetch__temp SET
                    new_ag_dokunr = _trg_ag_dokunr
                WHERE old_ag_dokunr = _src_ag_dokunr
                ;

            END LOOP;
        END IF;


        -- Kopie für alle Positionen durchführen
          -- muss reaktiv auf erfolgte Kopie sein, zwecks Abhängigkeiten (Positionsnummern)
        FOR _this__to_copy IN
            SELECT * FROM auftg__copy__fetch__temp ORDER BY old_ag_pos
        LOOP

            -- Wenn angehangen wird, dann Positionsnummer autom. neu ermitteln, vgl. auftg-Trigger.
            IF _opt_anhang THEN

                _this__to_copy.new_ag_pos := TWaWi.auftg__ag_pos__next( _trg_ag_astat, _trg_ag_nr );

                -- Neue Positionsnummer merken.
                UPDATE auftg__copy__fetch__temp SET
                    new_ag_pos = _this__to_copy.new_ag_pos
                WHERE old_ag_pos = _this__to_copy.old_ag_pos
                ;

                -- Neue Hauptpos-Bezüge entspr. neuer Positionsnummern merken.
                UPDATE auftg__copy__fetch__temp SET
                    new_ag_hpos = _this__to_copy.new_ag_pos
                WHERE old_ag_hpos = _this__to_copy.old_ag_pos
                ;

            END IF;

            -- Auftragsposition kopieren
            PERFORM
                tauftg.auftg_pos__copy(
                    -- Quelle
                    _this__to_copy.ag_id,
                    -- Ziel
                    _trg_ag_astat,
                    _trg_ag_nr,
                    _this__to_copy.new_ag_pos,
                    _this__to_copy.new_ag_dokunr,
                    -- Optionen
                    _opt_ag_bdat_leeren,
                    _opt_inkl_eigenschaften,
                    _opt_dokument,
                    -- Änderungen am Ziel
                      -- ag_hpos muss erstmal entfernt werden, da ag_pos < ag_hpos möglich ist (siehe Constraints).
                      -- unten per Update
                    null,
                      -- andere normal übergeben
                    _chg_ag_lkn,
                    _chg_ag_krzl,
                    _chg_ag_krzf,
                    _chg_ag_bda,
                    _chg_ag_an_nr,
                    _chg_ag_kukl,
                    _chg_ag_arab
                )
            ;

        END LOOP;


        -- Nicht in Kopie referenzierte Hauptpos-Bezüge entfernen
          -- wenn in anderen Auftrag kopiert wird
          -- Problem 1: Fehler, weil Position im Ziel nicht vorhanden ist.
          -- Problem 2: zufällige Verlinkung mit bereits vorhandener Position bei Anhang
        UPDATE auftg__copy__fetch__temp SET
            new_ag_hpos = null
        WHERE new_ag_hpos IS NOT NULL
          AND NOT EXISTS(
              SELECT true
              FROM auftg__copy__fetch__temp AS pos
              WHERE pos.new_ag_pos = auftg__copy__fetch__temp.new_ag_hpos
          )
          -- Kopie in anderen Auftrag
          AND (
                  ag_astat  <> _trg_ag_astat
              OR  ag_nr     <> _trg_ag_nr
          )
        ;


        -- In Auftragskopien Hauptpos-Bezüge herstellen.
          -- muss nachträglich erfolgen, da ag_pos < ag_hpos möglich ist (siehe Constraints).
        FOR _this__to_update IN
            SELECT * FROM auftg__copy__fetch__temp ORDER BY new_ag_pos
        LOOP

            UPDATE auftg SET
                ag_hpos = _this__to_update.new_ag_hpos
            WHERE ag_astat = _trg_ag_astat
              AND ag_nr = _trg_ag_nr
              AND ag_pos = _this__to_update.new_ag_pos
              AND ag_hpos IS DISTINCT FROM _this__to_update.new_ag_hpos
            ;

        END LOOP;

    END LOOP;


    -- Optionen
        -- Projekteintrag, vgl. orig. RTF-Skript #16015
        IF
                _opt_mit_projekt
            AND _chg_ag_an_nr IS NOT NULL
            AND _chg_ag_lkn   IS NOT NULL

        THEN

            INSERT INTO anl_personen
              ( anp_an_nr,     anp_ad_krz )
            SELECT
                _chg_ag_an_nr, _chg_ag_lkn
            WHERE NOT EXISTS(
                      SELECT true FROM anl_personen WHERE anp_an_nr = _chg_ag_an_nr AND anp_ad_krz = _chg_ag_lkn
                  )
            ;

        END IF;

        -- Verkaufspreise neu berechnen, vgl. orig. RTF-Skript #16015
        IF _opt_vk_preis_neu_berechnen THEN

            FOR _auftg_pos__vk_preis_neu_berechnen IN

                SELECT
                    ag_id
                FROM auftg
                WHERE ag_astat  = _trg_ag_astat
                  AND ag_nr     = _trg_ag_nr
                  AND NOT ag_vkptotalpos
                ORDER BY ag_pos

            LOOP
                PERFORM tauftg.auftg_pos__vk_preis_neu_berechnen( _auftg_pos__vk_preis_neu_berechnen );
            END LOOP;

        END IF;
    --


    -- Bereinigung
    DROP TABLE IF EXISTS auftg__copy__fetch__temp;


    RETURN;
  END $$ LANGUAGE plpgsql VOLATILE;
--


-- Ermittelt zu kopierenden Positionen entspr. Optionen
  -- mehrere Pos per LIKE
CREATE OR REPLACE FUNCTION tauftg.auftg__copy__fetch(
      -- Quelle
      _src_ag_id                  integer,
      _src_ag_astat               varchar,
      _src_ag_nr                  varchar,
      _src_ag_pos                 varchar, -- mehrere Pos per LIKE

      -- Optionen
      _opt_inkl_unterstruktur     boolean = false -- inkl. Auflösung der Unterstrukturen

  ) RETURNS SETOF auftg AS $$
  BEGIN

      -- Quelle per ID vorbereiten, wenn unvollständig.
      IF
              _src_ag_id IS NOT NULL
          AND (
                  _src_ag_astat IS NULL
              OR  _src_ag_nr    IS NULL
              OR  _src_ag_pos   IS NULL
          )

      THEN

          SELECT
              ag_astat,
              ag_nr,
              ag_pos
          FROM auftg
          WHERE ag_id = _src_ag_id
          INTO
              _src_ag_astat,
              _src_ag_nr,
              _src_ag_pos
          ;

      END IF;


      RETURN QUERY

          WITH RECURSIVE _tree AS (

              -- Einstieg
              SELECT
                  ag_id,
                  ag_pos,
                  ag_hpos,
                  1 AS depth,
                  ARRAY[ ag_pos ] AS pos_path
              FROM auftg
              WHERE ag_astat  = _src_ag_astat
                AND ag_nr     = _src_ag_nr
                AND ag_pos::varchar LIKE _src_ag_pos

              -- Rekursion: Ermittlung der Unterstrukturen
                -- wenn Option zur Auflösung aktiv
              UNION ALL
              SELECT
                  child.ag_id,
                  child.ag_pos,
                  child.ag_hpos,
                  depth + 1,
                  pos_path || child.ag_pos
              FROM auftg AS child
                JOIN _tree ON _tree.ag_pos = child.ag_hpos
              WHERE
                -- Auflösung der Unterstrukturen aktiv
                    _opt_inkl_unterstruktur IS TRUE
                -- bei allen Positionen nicht notwendig
                AND _src_ag_pos <> '%'
                -- aus identischem Auftrag
                AND child.ag_astat  = _src_ag_astat
                AND child.ag_nr     = _src_ag_nr
                -- Abbruch, wenn Position bereits im Pfad enthalten ist.
                AND NOT ARRAY[ child.ag_pos ] <@ _tree.pos_path
            )

          SELECT auftg.*
          FROM auftg
          WHERE ag_id IN ( SELECT _tree.ag_id FROM _tree)
          ORDER BY ag_pos
      ;

  END $$ LANGUAGE plpgsql STABLE;
--


-- einzelnen Auftragsposition kopieren
CREATE OR REPLACE FUNCTION tauftg.auftg_pos__copy(
      -- Quelle
      _src_ag_id              integer,

      -- Ziel
      _trg_ag_astat           varchar,  -- an diese Auftragssstruktur
      _trg_ag_nr              varchar,
      _trg_ag_pos             integer,  -- Wenn null, dann autom. neue Positionsnummern.
      _trg_ag_dokunr          integer,  -- Wenn null, dann neue Dokumentkopie inkl. Verlinkung.

      -- Optionen
      _opt_ag_bdat_leeren     boolean = false,  -- Option zum Leeren des originalen Bestelldatums d. Kunden
      _opt_inkl_eigenschaften boolean = false,  -- Option Eigenschaften/Parameter mit kopieren
      _opt_dokument           boolean = true,   -- Option mit Dokumentkopie

      -- Änderungen am Ziel
      _chg_ag_hpos            integer = null, -- Bezug zur Hauptposition wird entfernt oder muss explizit angg. werden.
      _chg_ag_lkn             varchar = null, -- Besteller
      _chg_ag_krzl            varchar = null, -- Lieferadresse
      _chg_ag_krzf            varchar = null, -- Rechnungsadresse
      _chg_ag_bda             varchar = null, -- Bestellnummer d. Kunden
      _chg_ag_an_nr           varchar = null, -- Projektnummer
      _chg_ag_kukl            integer = null, -- Kundenklasse
      _chg_ag_arab            numeric = null  -- Rabatt

  ) RETURNS void AS $$
  DECLARE
      _src_ag_dokunr    integer := ag_dokunr FROM auftg WHERE ag_id = _src_ag_id;
      _src_auftg_dbrid  varchar;
  BEGIN

    -- Fehlerbehandlung
      -- keine Quelle definiert
      IF NOT EXISTS( SELECT true FROM auftg WHERE ag_id = _src_ag_id ) THEN
          RAISE EXCEPTION '%', lang_text( 16872 );
      END IF;


      -- kein Ziel definiert
      IF
              _trg_ag_astat IS NULL
          OR  _trg_ag_nr    IS NULL

      THEN
          RAISE EXCEPTION '%', lang_text( 16873 );
      END IF;


      -- Ziel existiert bereits
      IF  EXISTS(
              SELECT true FROM auftg
              WHERE ag_astat = _trg_ag_astat
                AND ag_nr = _trg_ag_nr
                AND ag_pos = _trg_ag_pos
          )
      THEN
          RAISE EXCEPTION '%', lang_text( 16875 );
      END IF;

      -- Dokumentennummer ist ungültig
      IF
          -- Dokument kann weder kopiert
              _src_ag_dokunr IS NULL
          -- noch existiert es zur Verlinkung
          AND _trg_ag_dokunr IS NOT NULL
          AND NOT EXISTS( SELECT true FROM auftgdokutxt WHERE atd_dokunr = _trg_ag_dokunr )

      THEN
          RAISE EXCEPTION '%', lang_text( 16876 );
      END IF;
    --


    -- Auftragskopf
      IF
          NOT EXISTS( SELECT true FROM auftgtxt WHERE at_astat = _trg_ag_astat AND at_nr = _trg_ag_nr )
      THEN

          CREATE TEMP TABLE auftg_pos__copy__auftgtxt__temp AS
              SELECT
                  auftgtxt.*
              FROM auftg
                JOIN auftgtxt ON at_astat = ag_astat AND at_nr = ag_nr
              WHERE ag_id = _src_ag_id
          ;

          -- Neue IDs und neuen Auftragnummer
          UPDATE auftg_pos__copy__auftgtxt__temp SET
              at_id = nextval( 'auftgtxt_at_id_seq' ),
              dbrid = nextval( 'db_id_seq' ),
              insert_date = current_date,
              insert_by   = current_user,
              at_astat  = _trg_ag_astat,
              at_nr     = _trg_ag_nr
          ;

          -- Übernahme
          INSERT INTO auftgtxt  SELECT * FROM auftg_pos__copy__auftgtxt__temp;

          -- Bereinigung
          DROP TABLE IF EXISTS auftg_pos__copy__auftgtxt__temp;

      END IF;
    --


    -- Auftragsposition
      CREATE TEMP TABLE auftg_pos__copy__auftg__temp AS
          SELECT *
          FROM auftg
          WHERE ag_id = _src_ag_id
      ;

      -- Wenn neue AG-Pos explizit null ist, dann autom. ermitteln, vgl. auftg-Trigger.
      IF _trg_ag_pos IS NULL THEN
          _trg_ag_pos := TWaWi.auftg__ag_pos__next( _trg_ag_astat, _trg_ag_nr );
      END IF;

      -- Neue IDs und neuen Auftragnummer
      UPDATE auftg_pos__copy__auftg__temp SET
          ag_id = nextval( 'auftg_ag_id_seq' ),
          dbrid = nextval( 'db_id_seq' ),
          insert_date = current_date,
          insert_by   = current_user,
          ag_astat  = _trg_ag_astat,
          ag_nr     = _trg_ag_nr,
          ag_pos    = _trg_ag_pos,
          ag_dokunr = ifthen( _opt_dokument, coalesce( _trg_ag_dokunr, ag_dokunr ), null ),
          -- Defaults
          ag_bdat   = current_date,
          ag_datum  = current_date,
          ag_ownabk = null,
          ag_post4  = null,
          ag_stkl   = 0,
          ag_stkb   = 0,
          ag_stkf   = 0,
          ag_stkres = 0,
          ag_hest   = 0,
          ag_vkpbas = 0,
          ag_done   = false,
          ag_storno = false,
          ag_stornodat  = null,
          ag_kdatum = null,
          ag_ldatum = null,
          ag_ang_ag_id  = null,
          ag_kanf_nr  = null,
          -- Anpassungen
          ag_hpos   = _chg_ag_hpos,
          ag_lkn    = coalesce( nullif( trim( _chg_ag_lkn ),    ''), ag_lkn ),
          ag_krzl   = coalesce( nullif( trim( _chg_ag_krzl ),   ''), ag_krzl ),
          ag_krzf   = coalesce( nullif( trim( _chg_ag_krzf ),   ''), ag_krzf ),
          ag_bda    = coalesce( nullif( trim( _chg_ag_bda ),    ''), ag_bda ),
          ag_an_nr  = coalesce( nullif( trim( _chg_ag_an_nr ),  ''), ag_an_nr ),
          ag_kukl   = coalesce( _chg_ag_kukl, adk.ad_vpber, ag_kukl ),
          ag_arab   = coalesce( _chg_ag_arab, ag_arab ),
          ag_konto  = coalesce( art.ak_zeko, artcod.ac_konto_erl ),
          ag_ks     = coalesce( art.ak_ks, artcod.ac_ks )

      FROM art
        JOIN artcod ON ac_n = ak_ac
        LEFT JOIN adk ON ad_krz = _chg_ag_lkn
      WHERE ak_nr = ag_aknr
      ;

      -- originales Bestelldatum d. Kunden ggf. entfernen.
      IF _opt_ag_bdat_leeren IS TRUE THEN
          UPDATE auftg_pos__copy__auftg__temp SET ag_bdat = null;
      END IF;
    --


    -- Abzüge/Zuschläge Auftrag
      CREATE TEMP TABLE auftg_pos__copy__auftgabzu__temp AS
          SELECT *
          FROM auftgabzu
          WHERE az_ag_id = _src_ag_id
      ;

      -- Neue IDs und Verlinkung
      UPDATE auftg_pos__copy__auftgabzu__temp SET
          az_id = nextval( 'auftgabzu_az_id_seq' ),
          dbrid = nextval( 'db_id_seq' ),
          -- Defaults
          az_done   = false,
          az_bebnr  = null,
          -- Verlinkung zu neuer Auftragsposition
          az_ag_id = ag_id

      FROM auftg_pos__copy__auftg__temp
      ;
    --


    -- Dokument-Struktur kopieren
      IF
          -- wenn Quelle eine Dokumentnummer verzeichnet hat
              _src_ag_dokunr IS NOT NULL
          -- und Ziel noch nicht existiert
          AND NOT EXISTS( SELECT true FROM auftgdokutxt WHERE atd_dokunr = _trg_ag_dokunr )
          AND _opt_dokument

      THEN

          IF _trg_ag_dokunr IS NULL THEN
              _trg_ag_dokunr = nextval( 'auftg_ag_dokunr_seq' );
          END IF;

          -- Auftragsdokument
              CREATE TEMP TABLE auftg_pos__copy__auftgdokutxt__temp AS
                  SELECT *
                  FROM auftgdokutxt
                  WHERE atd_dokunr = _src_ag_dokunr
              ;

              -- Neue IDs
              UPDATE auftg_pos__copy__auftgdokutxt__temp SET
                  atd_dokunr = _trg_ag_dokunr,
                  dbrid = nextval( 'db_id_seq' ),
                  insert_date = current_date,
                  insert_by =   current_user
              ;

              -- Verlinkung mit neuem Auftrag
              UPDATE auftg_pos__copy__auftg__temp SET
                  ag_dokunr = _trg_ag_dokunr
              ;

              -- Text defaults Standardtexte abschalten #19684
              PERFORM TSystem.Settings__Set('belarzu__DISABLE__DEFAULT__TEXT', True);
          --

          -- Zahlungsplan des Auftragsdokuments
              CREATE TEMP TABLE auftg_pos__copy__auftgdokzahlplan__temp AS
                  SELECT *
                  FROM auftgdokzahlplan
                  WHERE azp_atd_dokunr = _src_ag_dokunr
              ;

              -- Neue IDs
              UPDATE auftg_pos__copy__auftgdokzahlplan__temp SET
                  azp_id  = nextval( 'auftgdokzahlplan_predefines_azp_id_seq' ),
                  dbrid   = nextval( 'db_id_seq' ),
                  insert_date = current_date,
                  insert_by   = current_user,
                  -- Defaults
                  azp_be_bnr  = null,
                  azp_status  = null,
                  -- Verlinkung mit neuem Dokument
                  azp_atd_dokunr = _trg_ag_dokunr
              ;
          --

          -- Übernahme
          INSERT INTO auftgdokutxt      SELECT * FROM auftg_pos__copy__auftgdokutxt__temp;
          INSERT INTO auftgdokzahlplan  SELECT * FROM auftg_pos__copy__auftgdokzahlplan__temp;

          -- Bereinigung
          DROP TABLE IF EXISTS auftg_pos__copy__auftgdokutxt__temp;
          DROP TABLE IF EXISTS auftg_pos__copy__auftgdokzahlplan__temp;
          PERFORM TSystem.Settings__Set('belarzu__DISABLE__DEFAULT__TEXT', False);

      END IF;
    --

    -- Übernahme
      PERFORM disableauftgtrigger();

      INSERT INTO auftg     SELECT * FROM auftg_pos__copy__auftg__temp      ORDER BY ag_id;
      INSERT INTO auftgabzu SELECT * FROM auftg_pos__copy__auftgabzu__temp  ORDER BY az_id;

      -- auch PrintSetting 'psPriceMainPos' übernehmen
      PERFORM
          TReporting.recnokeyword__print_setting__copy(
              'auftg',
              _src_ag_id,
              'auftg',
              (auftg_pos__copy__auftg__temp).ag_id
          )
      FROM auftg_pos__copy__auftg__temp
      ;

      PERFORM enableauftgtrigger();

      -- Eigenschaften/Parameter an Auftragsposition vollständig mit kopieren
      IF _opt_inkl_eigenschaften THEN

          _src_auftg_dbrid := dbrid FROM auftg WHERE ag_id = _src_ag_id;

          PERFORM
              TRecnoParam.CopyAll(
                  _src_auftg_dbrid,
                  auftg_pos__copy__auftg__temp.dbrid,
                  'auftg'
              )
          FROM auftg_pos__copy__auftg__temp
          ;

      END IF;
    --


    -- Bereinigung
    DROP TABLE IF EXISTS auftg_pos__copy__auftg__temp;
    DROP TABLE IF EXISTS auftg_pos__copy__auftgabzu__temp;


    RETURN;
  END $$ LANGUAGE plpgsql VOLATILE;
--


-- Auftrag: Verkauspreis neu berechnen
CREATE OR REPLACE FUNCTION tauftg.auftg_pos__vk_preis_neu_berechnen(
      _trg_ag_id  integer
  ) RETURNS void AS $$
  DECLARE
      _artikel_vkppreis__by__ag_pos record;
  BEGIN

      SELECT
          artikel_vkppreis.rab,
          artikel_vkppreis.vkp
      FROM auftg
        LEFT JOIN LATERAL
            artikel_vkppreis(
                ag_aknr, ag_lkn, ag_kukl, ag_stk_uf1, TSystem.Settings__Get( 'BASIS_W' ),
                ag_kurs, 1, coalesce( ag_ldatum, ag_kdatum )
            )
        ON true
      WHERE ag_id = _trg_ag_id
        AND NOT ag_vkptotalpos
      INTO
          _artikel_vkppreis__by__ag_pos
      ;


      UPDATE auftg SET
          ag_arab = _artikel_vkppreis__by__ag_pos.rab,
          ag_vkp  = _artikel_vkppreis__by__ag_pos.vkp
       WHERE ag_id = _trg_ag_id
        AND NOT ag_vkptotalpos
      ;


      RETURN;
  END $$ LANGUAGE plpgsql VOLATILE;
--
